/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.base.info;

import de.vandermeer.skb.base.info.DirectoryLoader;
import de.vandermeer.skb.base.info.DirectorySource;
import de.vandermeer.skb.base.info.FileSource;
import de.vandermeer.skb.base.info.FileSourceList;
import de.vandermeer.skb.interfaces.messagesets.IsErrorSetFT;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.filefilter.IOFileFilter;

public class CommonsDirectoryWalker
extends DirectoryWalker<FileSource>
implements DirectoryLoader {
    final DirectorySource source;
    final IsErrorSetFT errors = IsErrorSetFT.create();

    public CommonsDirectoryWalker(DirectorySource source, IOFileFilter dirFilter, IOFileFilter fileFilter) {
        super(dirFilter, fileFilter, -1);
        this.source = source;
        this.validateSource();
    }

    public CommonsDirectoryWalker(String root, IOFileFilter dirFilter, IOFileFilter fileFilter) {
        this(new DirectorySource(root), dirFilter, fileFilter);
    }

    @Override
    public FileSourceList load() {
        if (!this.errors.hasErrors()) {
            this.errors.clearErrorMessages();
            ArrayList<FileSource> ret = new ArrayList<FileSource>();
            try {
                File f = this.source.asFile();
                this.walk(f, ret);
            }
            catch (IOException e) {
                this.errors.addError("IOException while walking dir <{}> - {}", new Object[]{this.source.getSource(), e.getMessage()});
            }
            return new FileSourceList(ret);
        }
        return null;
    }

    @Override
    public DirectorySource getSource() {
        return this.source;
    }

    @Override
    public IsErrorSetFT getLoadErrors() {
        return this.errors;
    }

    protected void handleFile(File file, int depth, Collection<FileSource> results) throws IOException {
        results.add(new FileSource(file, this.source.getFullDirecoryName()));
    }
}

