/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.base.info;

import de.vandermeer.skb.base.info.AbstractDirectoryInfo;
import de.vandermeer.skb.base.info.InfoLocationOptions;
import de.vandermeer.skb.base.info.InfoSource;
import de.vandermeer.skb.base.info.ValidationOptions;
import de.vandermeer.skb.interfaces.messagesets.IsErrorSetFT;
import java.io.File;
import java.io.FileFilter;

public class DirectorySource
extends AbstractDirectoryInfo
implements InfoSource {
    public static final FileFilter DIRECTORIES_ONLY = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return f.exists() && f.isDirectory();
        }
    };

    public DirectorySource(String directory) {
        super(directory, InfoLocationOptions.TRY_CLASSPATH_THEN_FS);
    }

    public DirectorySource(String directory, InfoLocationOptions option) {
        super(directory, option);
    }

    @Override
    public Object getSource() {
        return this.file != null ? this.file : this.url;
    }

    @Override
    public IsErrorSetFT getInitError() {
        return this.errors;
    }

    @Override
    protected ValidationOptions valOption() {
        return ValidationOptions.AS_SOURCE;
    }

    @Override
    public String asString() {
        switch (this.asStringOpt) {
            case AS_STRING_FULL_DIRECTORY_NAME: {
                return this.getFullDirecoryName();
            }
            case AS_STRING_SET_ROOT_PATH: {
                return this.getSetRootPath();
            }
        }
        return null;
    }
}

