/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.base.info;

import de.vandermeer.skb.base.info.AbstractValidator;
import de.vandermeer.skb.base.info.ValidationOptions;
import java.io.File;
import org.apache.commons.lang3.StringUtils;

public class DirectoryValidator
extends AbstractValidator {
    File info;
    String original;

    public DirectoryValidator(String directory, ValidationOptions option) {
        if (StringUtils.isBlank((CharSequence)directory)) {
            this.errors.addError("directory is null or blank");
        } else {
            File f = new File(directory);
            this.validate(f, option);
            if (this.isValid()) {
                this.info = f;
                this.original = directory;
            }
        }
    }

    public DirectoryValidator(File directory, ValidationOptions option) {
        if (directory == null) {
            this.errors.addError("directory is null");
        } else {
            this.validate(directory, option);
            if (this.isValid()) {
                this.info = directory;
                this.original = null;
            }
        }
    }

    protected void validate(File directory, ValidationOptions option) {
        if (!directory.exists()) {
            this.errors.addError("directory <{}> does not exist in file system", new Object[]{directory.getAbsolutePath()});
        } else if (!directory.isDirectory()) {
            this.errors.addError("directory <{}> is not a directory", new Object[]{directory.getAbsolutePath()});
        } else if (directory.isHidden()) {
            this.errors.addError("directory <{}> is a hidden directory", new Object[]{directory.getAbsolutePath()});
        } else {
            switch (option) {
                case AS_SOURCE: {
                    if (directory.canRead()) break;
                    this.errors.addError("directory <{}> is not readable", new Object[]{directory.getAbsolutePath()});
                    break;
                }
                case AS_SOURCE_AND_TARGET: {
                    if (!directory.canRead()) {
                        this.errors.addError("directory <{}> is not readable", new Object[]{directory.getAbsolutePath()});
                    }
                    if (directory.canWrite()) break;
                    this.errors.addError("directory <{}> is not writable", new Object[]{directory.getAbsolutePath()});
                    break;
                }
                case AS_TARGET: {
                    if (directory.canWrite()) break;
                    this.errors.addError("directory <{}> is not writable", new Object[]{directory.getAbsolutePath()});
                }
            }
        }
    }

    @Override
    public File getInfo() {
        return this.info;
    }

    @Override
    public String getOriginal() {
        return this.original;
    }
}

