/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.base.info;

import de.vandermeer.skb.base.info.AbstractFileInfo;
import de.vandermeer.skb.base.info.InfoLocationOptions;
import de.vandermeer.skb.base.info.InfoSource;
import de.vandermeer.skb.base.info.ValidationOptions;
import de.vandermeer.skb.interfaces.messagesets.IsErrorSetFT;
import java.io.File;
import java.io.FileFilter;

public class FileSource
extends AbstractFileInfo
implements InfoSource {
    public static final FileFilter FILES_ONLY = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return f.exists() && f.isFile();
        }
    };

    public FileSource(File file, boolean doValidate) {
        super(file, doValidate);
    }

    public FileSource(File file, String setRoot) {
        super(file, setRoot);
    }

    public FileSource(File file) {
        super(file);
    }

    public FileSource(String fileName) {
        super(fileName, InfoLocationOptions.TRY_RESOURCE_THEN_FS);
    }

    public FileSource(String fileName, InfoLocationOptions option) {
        super(fileName, option);
    }

    public FileSource(String directory, String fileName) {
        super(directory, fileName, InfoLocationOptions.TRY_RESOURCE_THEN_FS);
    }

    public FileSource(String directory, String fileName, InfoLocationOptions option) {
        super(directory, fileName, option);
    }

    @Override
    public Object getSource() {
        return this.file != null ? this.file : this.url;
    }

    @Override
    public IsErrorSetFT getInitError() {
        return this.errors;
    }

    @Override
    protected ValidationOptions valOption() {
        return ValidationOptions.AS_SOURCE;
    }

    @Override
    public String asString() {
        switch (this.asStringOpt) {
            case AS_STRING_ABSOLUTE_NAME: {
                return this.getAbsoluteName();
            }
            case AS_STRING_ABSOLUTE_PATH: {
                return this.getAbsolutePath();
            }
            case AS_STRING_BASE_FILE_NAME: {
                return this.getBaseFileName();
            }
            case AS_STRING_FULL_FILE_NAME: {
                return this.getFullFileName();
            }
            case AS_STRING_ROOT_PATH: {
                return this.getRootPath();
            }
            case AS_STRING_SET_ROOT_NAME: {
                return this.getSetRootName();
            }
            case AS_STRING_SET_ROOT_PATH: {
                return this.getSetRootPath();
            }
            case AS_STRING__FILE_EXTENSION: {
                return this.getFileExtension();
            }
        }
        return null;
    }
}

