/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.base.info;

import de.vandermeer.skb.base.info.AbstractSource;
import de.vandermeer.skb.base.info.FileSource;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FileSourceList
extends AbstractSource {
    final List<FileSource> source;

    public FileSourceList(List<FileSource> fileSources) {
        if (fileSources == null) {
            this.source = null;
            this.errors.addError("constructor(List<FileSource>) - fileSources cannot be null");
        } else {
            this.source = fileSources;
        }
    }

    @Override
    public List<FileSource> getSource() {
        return this.source;
    }

    public FileSource[] getSourceAsArray() {
        return this.getSource().toArray(new FileSource[0]);
    }

    public File[] getSourceAsFileArray() {
        return this.getSourceAsFileSourceList().toArray(new File[0]);
    }

    public List<File> getSourceAsFileSourceList() {
        ArrayList<File> ret = new ArrayList<File>();
        Iterator iterator = this.getSource().iterator();
        while (iterator.hasNext()) {
            FileSource fs = (FileSource)iterator.next();
            ret.add(fs.asFile());
        }
        return ret;
    }
}

