/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.base.info;

import de.vandermeer.skb.base.info.AbstractFileInfo;
import de.vandermeer.skb.base.info.InfoLocationOptions;
import de.vandermeer.skb.base.info.InfoTarget;
import de.vandermeer.skb.base.info.ValidationOptions;
import de.vandermeer.skb.interfaces.messagesets.IsErrorSetFT;
import java.io.File;
import java.io.IOException;

public class FileTarget
extends AbstractFileInfo
implements InfoTarget {
    public FileTarget(File file, boolean doValidate) {
        super(file, doValidate);
    }

    public FileTarget(File file) {
        super(file);
    }

    public FileTarget(File file, String setRoot) {
        super(file, setRoot);
    }

    public FileTarget(String fileName) {
        super(fileName, InfoLocationOptions.TRY_RESOURCE_THEN_FS);
    }

    public FileTarget(String fileName, InfoLocationOptions option) {
        super(fileName, option);
    }

    public FileTarget(String directory, String fileName) {
        super(directory, fileName, InfoLocationOptions.TRY_RESOURCE_THEN_FS);
    }

    public FileTarget(String directory, String fileName, InfoLocationOptions option) {
        super(directory, fileName, option);
    }

    @Override
    public Object getTarget() {
        return this.file != null ? this.file : this.url;
    }

    @Override
    public IsErrorSetFT getInitError() {
        return this.errors;
    }

    @Override
    protected ValidationOptions valOption() {
        return ValidationOptions.AS_TARGET;
    }

    public static String createFile(String fn) {
        File file = new File(fn);
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            return e.getMessage();
        }
        return null;
    }

    @Override
    public String asString() {
        switch (this.asStringOpt) {
            case AS_STRING_ABSOLUTE_NAME: {
                return this.getAbsoluteName();
            }
            case AS_STRING_ABSOLUTE_PATH: {
                return this.getAbsolutePath();
            }
            case AS_STRING_BASE_FILE_NAME: {
                return this.getBaseFileName();
            }
            case AS_STRING_FULL_FILE_NAME: {
                return this.getFullFileName();
            }
            case AS_STRING_ROOT_PATH: {
                return this.getRootPath();
            }
            case AS_STRING_SET_ROOT_NAME: {
                return this.getSetRootName();
            }
            case AS_STRING_SET_ROOT_PATH: {
                return this.getSetRootPath();
            }
            case AS_STRING__FILE_EXTENSION: {
                return this.getFileExtension();
            }
        }
        return null;
    }
}

