/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.base.info;

import de.vandermeer.skb.base.info.AbstractValidator;
import de.vandermeer.skb.base.info.ValidationOptions;
import java.io.File;
import org.apache.commons.lang3.StringUtils;

public class FileValidator
extends AbstractValidator {
    File info;
    String original;

    public FileValidator(String file, ValidationOptions option) {
        if (StringUtils.isBlank((CharSequence)file)) {
            this.errors.addError("file is null or blank");
        } else {
            File f = new File(file);
            this.validate(f, option);
            if (this.isValid()) {
                this.info = f;
                this.original = file;
            }
        }
    }

    public FileValidator(File file, ValidationOptions option) {
        if (file == null) {
            this.errors.addError("file is null");
        } else {
            this.validate(file, option);
            if (this.isValid()) {
                this.info = file;
                this.original = null;
            }
        }
    }

    protected void validate(File file, ValidationOptions option) {
        if (!file.exists()) {
            this.errors.addError("file <{}> does not exist in file system", new Object[]{file.getAbsolutePath()});
        } else if (!file.isFile()) {
            this.errors.addError("file <{}> is not a file", new Object[]{file.getAbsolutePath()});
        }
        if (file.isHidden()) {
            this.errors.addError("file <{}> is a hidden file", new Object[]{file.getAbsolutePath()});
        } else {
            switch (option) {
                case AS_SOURCE: {
                    if (file.canRead()) break;
                    this.errors.addError("file <{}> is not readable", new Object[]{file.getAbsolutePath()});
                    break;
                }
                case AS_SOURCE_AND_TARGET: {
                    if (!file.canRead()) {
                        this.errors.addError("file <{}> is not readable", new Object[]{file.getAbsolutePath()});
                    }
                    if (file.canWrite()) break;
                    this.errors.addError("file <{}> is not writable", new Object[]{file.getAbsolutePath()});
                    break;
                }
                case AS_TARGET: {
                    if (file.canWrite()) break;
                    this.errors.addError("file <{}> is not writable", new Object[]{file.getAbsolutePath()});
                }
            }
        }
    }

    @Override
    public File getInfo() {
        return this.info;
    }

    @Override
    public String getOriginal() {
        return this.original;
    }
}

