/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.base.info;

import de.vandermeer.skb.base.info.AbstractLoader;
import de.vandermeer.skb.base.info.DirectoryLoader;
import de.vandermeer.skb.base.info.FileSource;
import de.vandermeer.skb.base.info.FileSourceList;
import de.vandermeer.skb.base.info.FileSourceListLoader;
import de.vandermeer.skb.base.info.PropertyFileLoader;
import java.util.List;
import java.util.Properties;

public class PropertyArrayLoader
extends AbstractLoader
implements FileSourceListLoader {
    FileSourceList source;
    DirectoryLoader dl;

    public PropertyArrayLoader(DirectoryLoader dl) {
        this.dl = dl;
    }

    public PropertyArrayLoader(FileSourceList source) {
        this.source = source;
    }

    public PropertyArrayLoader(List<FileSource> files) {
        this.source = new FileSourceList(files);
    }

    public Properties[] load() {
        this.errors.clearErrorMessages();
        if (this.dl != null) {
            if (!this.dl.validateSource()) {
                this.errors.addAllErrors(this.dl.getLoadErrors());
                return null;
            }
            this.source = this.dl.load();
        } else if (!this.validateSource()) {
            return null;
        }
        Properties[] ret = new Properties[this.source.getSource().size()];
        Object files = this.source.getSource();
        for (int i = 0; i < files.size(); ++i) {
            ret[i] = new PropertyFileLoader((FileSource)files.get(i)).load();
        }
        return ret;
    }

    @Override
    public FileSourceList getSource() {
        return this.source;
    }
}

