/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.base.info;

import de.vandermeer.skb.base.info.AbstractLoader;
import de.vandermeer.skb.base.info.FileLoader;
import de.vandermeer.skb.base.info.FileSource;
import java.io.IOException;
import java.util.Properties;

public class PropertyFileLoader
extends AbstractLoader
implements FileLoader {
    final FileSource source;

    public PropertyFileLoader(FileSource source) {
        this.source = source;
        if (!source.isValid()) {
            this.errors.addError("{}: problems creating file source - {}", new Object[]{"property file loader", this.source.getInitError().render()});
        }
    }

    public PropertyFileLoader(String fileName) {
        this.source = new FileSource(fileName);
        if (!this.source.isValid()) {
            this.errors.addError("{}: problems creating file source - {}", new Object[]{"property file loader", this.source.getInitError().render()});
        }
    }

    @Override
    public Properties load() {
        this.errors.clearErrorMessages();
        if (!this.validateSource()) {
            return null;
        }
        Properties ret = new Properties();
        try {
            ret.load(this.source.asURL().openStream());
        }
        catch (IOException e) {
            this.errors.addError("{}: cannot load property file {}, IO exception\n-->{}", new Object[]{"pfl", this.source.getSource(), e.getMessage()});
            return null;
        }
        catch (Exception e) {
            this.errors.addError("{}: cannot load property file {}, general exception\n-->{}", new Object[]{"pfl", this.source.getSource(), e.getMessage()});
            return null;
        }
        return ret;
    }

    @Override
    public FileSource getSource() {
        return this.source;
    }
}

