/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.base.info;

import de.vandermeer.skb.base.info.AbstractValidator;
import de.vandermeer.skb.base.info.STValidator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupDir;
import org.stringtemplate.v4.STGroupFile;
import org.stringtemplate.v4.STGroupString;

public class STGroupValidator
extends AbstractValidator {
    STGroup info;
    Map<String, Set<String>> original;

    public STGroupValidator(STGroup stg, Map<String, Set<String>> expectedChunks) {
        if (stg == null) {
            this.errors.addError("stg is null");
        }
        if (expectedChunks == null) {
            this.errors.addError("expectedChunks is null");
        }
        if (!this.getValidationErrors().hasErrors()) {
            this.validate(stg, expectedChunks);
            if (this.isValid()) {
                this.info = stg;
                this.original = expectedChunks;
            }
        }
    }

    protected void validate(STGroup stg, Map<String, Set<String>> expectedChunks) {
        for (String s : expectedChunks.keySet()) {
            if (s == null || "".equals(s)) continue;
            if (stg.isDefined(s)) {
                STValidator stv = new STValidator(stg.getInstanceOf(s), expectedChunks.get(s));
                this.errors.addAllErrors(stv.getValidationErrors());
                continue;
            }
            this.errors.addError("STGroup <{}> does not define mandatory template <{}>", new Object[]{STGroupValidator.GET_STG_NAME(stg), s});
        }
    }

    public STGroup getInfo() {
        return this.info;
    }

    @Override
    public Map<String, Set<String>> getOriginal() {
        return this.original;
    }

    public static final String GET_STG_NAME(STGroup stg) {
        String ret = null;
        if (stg instanceof STGroupFile) {
            ret = ((STGroupFile)stg).fileName;
        } else if (stg instanceof STGroupString) {
            ret = ((STGroupString)stg).sourceName;
        } else if (stg instanceof STGroupDir) {
            ret = ((STGroupDir)stg).groupDirName;
        }
        return StringUtils.substringBeforeLast((String)ret, (String)".");
    }
}

