/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.base.info;

import de.vandermeer.skb.base.info.AbstractValidator;
import java.util.Map;
import java.util.Set;
import org.stringtemplate.v4.ST;

public class STValidator
extends AbstractValidator {
    ST info;
    Set<String> original;

    public STValidator(ST st, Set<String> expectedArguments) {
        if (st == null) {
            this.errors.addError("ST is null");
        }
        if (expectedArguments == null) {
            this.errors.addError("expectedArguments is null");
        }
        if (!this.getValidationErrors().hasErrors()) {
            this.validate(st, expectedArguments);
            if (this.isValid()) {
                this.info = st;
                this.original = expectedArguments;
            }
        }
    }

    protected void validate(ST st, Set<String> expectedArguments) {
        Map formalArgs = st.impl.formalArguments;
        if (formalArgs == null) {
            for (String s : expectedArguments) {
                this.errors.addError("ST <{}> does not define argument <{}>", new Object[]{st.getName(), s});
            }
        } else {
            for (String s : expectedArguments) {
                if (formalArgs.containsKey(s)) continue;
                this.errors.addError("ST <{}> does not define argument <{}>", new Object[]{st.getName(), s});
            }
        }
    }

    public ST getInfo() {
        return this.info;
    }

    @Override
    public Set<String> getOriginal() {
        return this.original;
    }
}

