/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.base.info;

import de.vandermeer.skb.base.info.AbstractLoader;
import de.vandermeer.skb.base.info.DirectoryLoader;
import de.vandermeer.skb.base.info.DirectorySource;
import de.vandermeer.skb.base.info.FileSource;
import de.vandermeer.skb.base.info.FileSourceList;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.text.StrBuilder;

public class SimpleDirectoryScanner
extends AbstractLoader
implements DirectoryLoader {
    final DirectorySource source;
    int scDir;
    int scDirUnreadable;
    int scFiles;
    int scFilesUnreadable;
    final List<String> warnings;
    final List<String> infos;

    public SimpleDirectoryScanner(DirectorySource source) {
        this.source = source;
        this.validateSource();
        this.warnings = new ArrayList<String>();
        this.infos = new ArrayList<String>();
    }

    public void clear() {
        this.errors.clearErrorMessages();
        this.warnings.clear();
        this.infos.clear();
        this.scDir = 0;
        this.scDirUnreadable = 0;
        this.scFiles = 0;
        this.scFilesUnreadable = 0;
    }

    protected List<FileSource> getFiles() {
        this.clear();
        File f = this.source.asFile();
        List<FileSource> ret = this.doScan(f);
        this.doInfo();
        return ret;
    }

    void doInfo() {
        this.infos.add("scanned directories:    " + this.scDir);
        this.infos.add("unreadable directories: " + this.scDirUnreadable);
        this.infos.add("found files:      " + this.scFiles);
        this.infos.add("unreadable files: " + this.scFilesUnreadable);
    }

    protected List<FileSource> doScan(File fDir) {
        ArrayList<FileSource> ret = new ArrayList<FileSource>();
        if (fDir != null && fDir.exists() && !fDir.isHidden()) {
            for (File entry : fDir.listFiles()) {
                if (entry.isHidden()) continue;
                if (!entry.isDirectory()) {
                    ++this.scFiles;
                    if (entry.canRead()) {
                        ret.add(new FileSource(entry, this.source.getSetRootPath()));
                        continue;
                    }
                    ++this.scFilesUnreadable;
                    this.warnings.add("found file <" + entry.getAbsolutePath() + "> but cannot read, ignore");
                    continue;
                }
                if (!entry.isDirectory()) continue;
                ++this.scDir;
                if (entry.canRead()) {
                    ret.addAll(this.doScan(entry));
                    continue;
                }
                ++this.scDirUnreadable;
                this.warnings.add("found directory <" + entry.getAbsolutePath() + "> but cannot read, ignore");
            }
        }
        return ret;
    }

    public List<String> lastWarnings() {
        return this.warnings;
    }

    public List<String> lastInfos() {
        return this.infos;
    }

    public String toString() {
        StrBuilder ret = new StrBuilder(100);
        ret.append("infos: ").append(this.infos.size());
        if (this.infos.size() > 0) {
            ret.appendNewLine().append("  - ");
            ret.appendWithSeparators(this.infos, "\n  - ");
        }
        ret.appendNewLine();
        ret.append("warnings: ").append(this.warnings.size());
        if (this.warnings.size() > 0) {
            ret.appendNewLine().append("  - ");
            ret.appendWithSeparators(this.warnings, "\n  - ");
        }
        ret.appendNewLine();
        ret.append("errors: ").append(this.infos.size());
        if (this.errors.hasErrors()) {
            ret.appendNewLine().append("  - ");
            ret.append(this.errors.render());
        }
        ret.appendNewLine();
        return ret.toString();
    }

    @Override
    public DirectorySource getSource() {
        return this.source;
    }

    @Override
    public FileSourceList load() {
        if (this.getSource().isValid()) {
            return new FileSourceList(this.getFiles());
        }
        return null;
    }
}

