/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.base.info;

import de.vandermeer.skb.base.info.AbstractLoader;
import de.vandermeer.skb.base.info.FileLoader;
import de.vandermeer.skb.base.info.FileSource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Scanner;

public class StringFileLoader
extends AbstractLoader
implements FileLoader {
    final FileSource source;

    public StringFileLoader(FileSource source) {
        this.source = source;
        if (!source.isValid()) {
            this.errors.addError("{}: problems creating file source - {}", new Object[]{"string file loader", this.source.getInitError().render()});
        }
    }

    public StringFileLoader(String fileName) {
        this.source = new FileSource(fileName);
        if (!this.source.isValid()) {
            this.errors.addError("{}: problems creating file source - {}", new Object[]{"string file loader", this.source.getInitError().render()});
        }
    }

    @Override
    public String load() {
        String ret = null;
        this.errors.clearErrorMessages();
        if (!this.validateSource()) {
            return ret;
        }
        Scanner s = null;
        try {
            s = new Scanner(this.source.asURL().openStream()).useDelimiter("\\Z");
            ret = s.next();
            s.close();
        }
        catch (FileNotFoundException ex) {
            this.errors.addError("{}: unexpected file not found exception - {}", new Object[]{"string file loader", ex.getMessage()});
            return ret;
        }
        catch (IOException exio) {
            this.errors.addError("{}: unexpected IO not found exception - {}", new Object[]{"string file loader", exio.getMessage()});
            return ret;
        }
        return ret;
    }

    @Override
    public FileSource getSource() {
        return this.source;
    }
}

