/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.base.info;

import de.vandermeer.skb.base.info.AbstractWriter;
import de.vandermeer.skb.base.info.FileTarget;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class StringFileWriter
extends AbstractWriter {
    final FileTarget target;

    public StringFileWriter(FileTarget target) {
        this.target = target;
        if (!target.isValid()) {
            this.errors.addError("{}: problems creating file target - {}", new Object[]{"string file writer", this.target.getInitError().render()});
        }
    }

    public StringFileWriter(String fileName) {
        this.target = new FileTarget(fileName);
        if (!this.target.isValid()) {
            this.errors.addError("{}: problems creating file target - {}", new Object[]{"string file writer", this.target.getInitError().render()});
        }
    }

    @Override
    public boolean write(Object content) {
        this.errors.clearErrorMessages();
        if (!this.validateTarget()) {
            return false;
        }
        if (content == null) {
            throw new IllegalArgumentException("content was null");
        }
        if (!(content instanceof String)) {
            throw new IllegalArgumentException("content was not of type String");
        }
        try {
            FileUtils.writeStringToFile((File)this.target.asFile(), (String)content.toString());
        }
        catch (IOException e) {
            this.errors.addError("{}: IO exception writing to file w/writeStringToFile()", new Object[]{"string file writer"});
            return false;
        }
        return true;
    }

    @Override
    public FileTarget getTarget() {
        return this.target;
    }
}

