/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.base.managers;

import de.vandermeer.skb.base.managers.MessageRenderer;
import de.vandermeer.skb.base.managers.MessageTypeHandler;
import de.vandermeer.skb.base.message.E_MessageType;
import de.vandermeer.skb.base.message.Message5WH;
import de.vandermeer.skb.base.message.Message5WH_Builder;
import de.vandermeer.skb.interfaces.FormattingTupleWrapper;
import de.vandermeer.skb.interfaces.categories.has.HasToStringStyle;
import de.vandermeer.skb.interfaces.messagesets.HasErrorSet;
import de.vandermeer.skb.interfaces.messagesets.HasInfoSet;
import de.vandermeer.skb.interfaces.messagesets.HasWarningSet;
import de.vandermeer.skb.interfaces.messagesets.IsMessageSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;

public class MessageMgr
implements HasToStringStyle {
    protected final LinkedHashMap<String, E_MessageType> messages;
    protected final Map<E_MessageType, MessageTypeHandler> messageHandlers;
    protected final boolean doCollectMessages;
    protected MessageRenderer renderer = null;
    protected final STGroup max100stg = new STGroupFile("de/vandermeer/skb/base/managers/msg-manager.stg");
    protected final Object appID;

    public static final Map<String, Set<String>> loadChunks() {
        return new HashMap<String, Set<String>>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("max", new HashSet<String>(){
                    private static final long serialVersionUID = 1L;
                    {
                        this.add("name");
                        this.add("number");
                        this.add("type");
                    }
                });
            }
        };
    }

    public static Message5WH createInfoMessage(String what, Object ... obj) {
        return new Message5WH_Builder().addWhat(FormattingTupleWrapper.create((String)what, (Object[])obj)).setType(E_MessageType.INFO).build();
    }

    public static Message5WH createWarningMessage(String what, Object ... obj) {
        return new Message5WH_Builder().addWhat(FormattingTupleWrapper.create((String)what, (Object[])obj)).setType(E_MessageType.WARNING).build();
    }

    public static Message5WH createErrorMessage(String what, Object ... obj) {
        return new Message5WH_Builder().addWhat(FormattingTupleWrapper.create((String)what, (Object[])obj)).setType(E_MessageType.ERROR).build();
    }

    MessageMgr(Object appID, Map<E_MessageType, MessageTypeHandler> messageHandlers, boolean doCollectMessages) {
        this.messages = new LinkedHashMap();
        this.appID = appID;
        this.messageHandlers = new HashMap<E_MessageType, MessageTypeHandler>();
        this.messageHandlers.putAll(messageHandlers);
        this.doCollectMessages = doCollectMessages;
        this.renderer = new MessageRenderer();
    }

    public MessageMgr setRenderer(MessageRenderer renderer) {
        if (renderer != null) {
            this.renderer = renderer;
        }
        return this;
    }

    public Collection<String> getMessageCollection() {
        return this.messages.keySet();
    }

    public Map<String, E_MessageType> getMessageMap() {
        return this.messages;
    }

    public boolean hasErrors() {
        if (this.messageHandlers.containsKey((Object)E_MessageType.ERROR)) {
            return this.messageHandlers.get((Object)E_MessageType.ERROR).getCount() != 0;
        }
        return false;
    }

    public boolean hasWarnings() {
        if (this.messageHandlers.containsKey((Object)E_MessageType.WARNING)) {
            return this.messageHandlers.get((Object)E_MessageType.WARNING).getCount() != 0;
        }
        return false;
    }

    public boolean hasInfos() {
        if (this.messageHandlers.containsKey((Object)E_MessageType.INFO)) {
            return this.messageHandlers.get((Object)E_MessageType.INFO).getCount() != 0;
        }
        return false;
    }

    public int getMessageCount(E_MessageType type) {
        if (this.messageHandlers.containsKey((Object)type)) {
            return this.messageHandlers.get((Object)type).getCount();
        }
        return -1;
    }

    public boolean isEnabledFor(E_MessageType type) {
        if (!this.messageHandlers.containsKey((Object)type)) {
            return false;
        }
        return this.messageHandlers.get((Object)type).isEnabled();
    }

    protected boolean report(Message5WH message) {
        if (message == null) {
            return false;
        }
        E_MessageType type = message.getType();
        if (!this.messageHandlers.containsKey((Object)message.getType())) {
            return false;
        }
        MessageTypeHandler handler = this.messageHandlers.get((Object)message.getType());
        String template = this.renderer.render(message);
        handler.handleMessage(template, type, this.max100stg.getInstanceOf("max"), this.appID);
        this.messages.put(template, type);
        return true;
    }

    protected boolean report(IsMessageSet messageSet) {
        if (messageSet == null) {
            return false;
        }
        E_MessageType type = null;
        if (messageSet.isErrorSet()) {
            type = E_MessageType.ERROR;
        } else if (messageSet.isWarningSet()) {
            type = E_MessageType.WARNING;
        } else if (messageSet.isInfoSet()) {
            type = E_MessageType.INFO;
        } else {
            return false;
        }
        if (!this.messageHandlers.containsKey((Object)type)) {
            return false;
        }
        MessageTypeHandler handler = this.messageHandlers.get((Object)type);
        String template = messageSet.render();
        handler.handleMessage(template, type, this.max100stg.getInstanceOf("max"), this.appID);
        this.messages.put(template, type);
        return true;
    }

    protected boolean reportKnownClasses(Object message) {
        boolean ret = true;
        if (message instanceof Message5WH) {
            ret &= this.report((Message5WH)message);
        } else if (message instanceof IsMessageSet) {
            ret &= this.report((IsMessageSet)message);
        } else if (message instanceof HasErrorSet) {
            ret &= this.report((IsMessageSet)((HasErrorSet)message).getErrorSet());
        } else if (message instanceof HasWarningSet) {
            ret &= this.report((IsMessageSet)((HasWarningSet)message).getWarningSet());
        } else if (message instanceof HasInfoSet) {
            ret &= this.report((IsMessageSet)((HasInfoSet)message).getInfoSet());
        }
        return ret;
    }

    public boolean report(Object obj) {
        if (obj == null) {
            return false;
        }
        boolean ret = true;
        if (obj instanceof Iterable) {
            for (Object o : (Iterable)obj) {
                ret &= this.reportKnownClasses(o);
            }
        } else if (obj instanceof Iterator) {
            while (((Iterator)obj).hasNext()) {
                ret &= this.reportKnownClasses(((Iterator)obj).next());
            }
        } else if (obj instanceof Object[]) {
            for (Object o : (Object[])obj) {
                ret &= this.reportKnownClasses(o);
            }
        } else {
            ret &= this.reportKnownClasses(obj);
        }
        return ret;
    }

    public MessageMgr clear() {
        for (MessageTypeHandler handler : this.messageHandlers.values()) {
            handler.clear();
        }
        this.messages.clear();
        return this;
    }

    public String toString() {
        ToStringBuilder ret = new ToStringBuilder((Object)this, this.getStyle());
        return ret.toString();
    }
}

