/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.base.managers;

import de.vandermeer.skb.base.managers.MessageMgr;
import de.vandermeer.skb.base.managers.MessageTypeHandler;
import de.vandermeer.skb.base.message.E_MessageType;
import de.vandermeer.skb.interfaces.messagesets.IsErrorSetFT;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class MessageMgrBuilder {
    protected final IsErrorSetFT buildErrors;
    protected final Map<E_MessageType, MessageTypeHandler> messageHandlers;
    protected boolean doCollectMessages;
    protected final Object appID;

    public MessageMgrBuilder(Object appID) {
        if (appID == null) {
            throw new IllegalArgumentException("appID cannot be null");
        }
        if (StringUtils.isBlank((CharSequence)appID.toString())) {
            throw new IllegalArgumentException("appID cannot be blank");
        }
        this.appID = appID;
        this.messageHandlers = new HashMap<E_MessageType, MessageTypeHandler>();
        this.buildErrors = IsErrorSetFT.create();
    }

    public IsErrorSetFT getBuildErrors() {
        return this.buildErrors;
    }

    public MessageMgrBuilder setHandler(E_MessageType type) {
        if (type != null) {
            this.messageHandlers.put(type, new MessageTypeHandler(type));
        } else {
            this.buildErrors.addError("{}: cannot add handler for empty type", new Object[]{this.getClass().getSimpleName()});
        }
        return this;
    }

    public MessageMgrBuilder setHandler(E_MessageType type, int maxCount) {
        if (type != null) {
            this.messageHandlers.put(type, new MessageTypeHandler(type, maxCount));
        } else {
            this.buildErrors.addError("{}: cannot add handler for empty type", new Object[]{this.getClass().getSimpleName()});
        }
        return this;
    }

    public MessageMgrBuilder setHandler(E_MessageType type, Logger logger) {
        if (type != null) {
            this.messageHandlers.put(type, new MessageTypeHandler(type, logger));
        } else {
            this.buildErrors.addError("{}: cannot add handler for empty type", new Object[]{this.getClass().getSimpleName()});
        }
        return this;
    }

    public MessageMgrBuilder setHandler(E_MessageType type, int maxCount, Logger logger) {
        if (type != null) {
            this.messageHandlers.put(type, new MessageTypeHandler(type, maxCount, logger));
        } else {
            this.buildErrors.addError("{}: cannot add handler for empty type", new Object[]{this.getClass().getSimpleName()});
        }
        return this;
    }

    public MessageMgrBuilder enableMessageCollection() {
        this.doCollectMessages = true;
        return this;
    }

    public MessageMgr build() {
        if (this.messageHandlers.size() == 0) {
            this.buildErrors.addError("no message handlers set");
            return null;
        }
        return new MessageMgr(this.appID, this.messageHandlers, this.doCollectMessages);
    }
}

