/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.base.managers;

import de.vandermeer.skb.base.info.STGroupValidator;
import de.vandermeer.skb.base.message.Message5WH;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrBuilder;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;

public class MessageRenderer {
    protected STGroup stg;
    public static String DEFAULT_STG_FN = "de/vandermeer/skb/base/managers/5wh.stg";
    public static STGroup DEFAULT_STG = new STGroupFile(DEFAULT_STG_FN);
    public static final Map<String, Set<String>> STG_CHUNKS = new HashMap<String, Set<String>>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("where", new HashSet<String>(){
                private static final long serialVersionUID = 1L;
                {
                    this.add("location");
                    this.add("line");
                    this.add("column");
                }
            });
            this.put("message5wh", new HashSet<String>(){
                private static final long serialVersionUID = 1L;
                {
                    this.add("reporter");
                    this.add("type");
                    this.add("who");
                    this.add("when");
                    this.add("where");
                    this.add("what");
                    this.add("why");
                    this.add("how");
                }
            });
        }
    };

    public MessageRenderer() {
        this.stg = DEFAULT_STG;
        this.validateSTG();
    }

    public MessageRenderer(STGroup stg) {
        this.stg = stg;
        this.validateSTG();
    }

    public MessageRenderer(String filename) {
        if (StringUtils.isBlank((CharSequence)filename)) {
            throw new IllegalArgumentException("filename cannot be blank (null or empty)");
        }
        this.stg = new STGroupFile(filename);
        this.validateSTG();
    }

    protected void validateSTG() {
        if (this.stg == null) {
            throw new IllegalArgumentException("stg is null");
        }
        STGroupValidator stgv = new STGroupValidator(this.stg, STG_CHUNKS);
        if (stgv.getValidationErrors().hasErrors()) {
            throw new IllegalArgumentException(stgv.getValidationErrors().render());
        }
    }

    public String render(Message5WH msg) {
        if (msg != null) {
            ST ret = this.stg.getInstanceOf("message5wh");
            if (msg.getWhereLocation() != null) {
                ST where = this.stg.getInstanceOf("where");
                where.add("location", msg.getWhereLocation());
                if (msg.getWhereLine() > 0) {
                    where.add("line", (Object)msg.getWhereLine());
                }
                if (msg.getWhereColumn() > 0) {
                    where.add("column", (Object)msg.getWhereColumn());
                }
                ret.add("where", (Object)where);
            }
            ret.add("reporter", msg.getReporter());
            if (msg.getType() != null) {
                HashMap<String, Boolean> typeMap = new HashMap<String, Boolean>();
                typeMap.put(msg.getType().toString(), true);
                ret.add("type", typeMap);
            }
            if (msg.getWhat() != null && !StringUtils.isBlank((CharSequence)msg.getWhat().toString())) {
                ret.add("what", (Object)msg.getWhat());
            }
            ret.add("who", msg.getWho());
            ret.add("when", msg.getWhen());
            ret.add("why", (Object)msg.getWhy());
            ret.add("how", (Object)msg.getHow());
            return ret.render();
        }
        return "";
    }

    public String render(Collection<Message5WH> messages) {
        StrBuilder ret = new StrBuilder(50);
        for (Message5WH msg : messages) {
            ret.appendln(this.render(msg));
        }
        return ret.toString();
    }
}

