/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.base.managers;

import de.vandermeer.skb.base.message.E_MessageType;
import de.vandermeer.skb.interfaces.MessageConsole;
import org.slf4j.Logger;
import org.stringtemplate.v4.ST;

class MessageTypeHandler {
    protected int count;
    protected int maxCount;
    protected boolean useSkbConsole;
    protected Logger logger;
    protected final E_MessageType type;

    MessageTypeHandler(E_MessageType type) {
        this(type, 0);
    }

    MessageTypeHandler(E_MessageType type, int maxCount) {
        this.type = type;
        this.maxCount = maxCount > 0 ? maxCount : -1;
        this.useSkbConsole = true;
        this.count = 0;
    }

    MessageTypeHandler(E_MessageType type, int maxCount, Logger logger) {
        this(type, maxCount);
        if (logger != null) {
            this.useSkbConsole = false;
            this.logger = logger;
        }
    }

    MessageTypeHandler(E_MessageType type, Logger logger) {
        this(type, 0, logger);
    }

    public int getCount() {
        return this.count;
    }

    public void clear() {
        this.count = 0;
    }

    public boolean isEnabled() {
        if (this.useSkbConsole) {
            return MessageConsole.PRINT_MESSAGES;
        }
        switch (this.type) {
            case INFO: {
                return this.logger.isInfoEnabled();
            }
            case WARNING: {
                return this.logger.isWarnEnabled();
            }
            case ERROR: {
                return this.logger.isErrorEnabled();
            }
        }
        return false;
    }

    public void handleMessage(String message, E_MessageType type, ST max100, Object appID) {
        ++this.count;
        boolean doMax = false;
        if (this.maxCount != -1 && this.count > this.maxCount) {
            max100.add("name", appID);
            max100.add("number", (Object)this.maxCount);
            doMax = true;
        }
        if (this.useSkbConsole) {
            switch (type) {
                case ERROR: {
                    MessageConsole.conError((String)message);
                    if (!doMax) break;
                    MessageConsole.conError((String)max100.render());
                    break;
                }
                case INFO: {
                    MessageConsole.conInfo((String)message);
                    if (!doMax) break;
                    MessageConsole.conError((String)max100.render());
                    break;
                }
                case WARNING: {
                    MessageConsole.conWarn((String)message);
                    if (!doMax) break;
                    MessageConsole.conError((String)max100.render());
                }
            }
        } else {
            switch (type) {
                case ERROR: {
                    this.logger.error(message);
                    if (!doMax) break;
                    this.logger.error(max100.render());
                    break;
                }
                case INFO: {
                    this.logger.info(message);
                    if (!doMax) break;
                    this.logger.error(max100.render());
                    break;
                }
                case WARNING: {
                    this.logger.warn(message);
                    if (!doMax) break;
                    this.logger.error(max100.render());
                }
            }
        }
    }
}

