/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.base.message;

import de.vandermeer.skb.base.message.E_MessageType;
import de.vandermeer.skb.interfaces.categories.has.HasToStringStyle;
import de.vandermeer.skb.interfaces.render.DoesRender;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.text.StrBuilder;

public class Message5WH
implements DoesRender,
HasToStringStyle {
    private Object who;
    private StrBuilder what;
    protected Object whereLocation;
    protected int whereLine;
    protected int whereColumn;
    private Object when;
    private StrBuilder why;
    private StrBuilder how;
    private Object reporter;
    private E_MessageType type;

    Message5WH(Object who, StrBuilder what, Object whereLocation, int whereLine, int whereColumn, Object when, StrBuilder why, StrBuilder how, Object reporter, E_MessageType type) {
        this.who = who;
        this.what = what;
        this.whereLocation = whereLocation;
        this.whereLine = whereLine;
        this.whereColumn = whereColumn;
        this.when = when;
        this.why = why;
        this.how = how;
        this.reporter = reporter;
        this.type = type;
    }

    public String render() {
        StrBuilder ret = new StrBuilder(100);
        StrBuilder where = null;
        if (this.getWhereLocation() != null) {
            where = new StrBuilder(30);
            where.append(this.whereLocation);
            if (this.whereLine > 0 && this.whereColumn > 0) {
                where.append(' ').append(this.whereLine).append(':').append(this.whereColumn).append(' ');
            } else if (this.whereLine < 1 && this.whereColumn < 1) {
                where.append(' ');
            } else if (this.whereLine < 1) {
                where.append(" -:").append(this.whereColumn).append(' ');
            } else if (this.whereColumn < 1) {
                where.append(' ').append(this.whereLine).append(":- ");
            }
        }
        if (this.reporter != null) {
            ret.append(this.reporter).append(": ");
        }
        if (this.what != null) {
            ret.append(this.type.name().toLowerCase()).append(' ');
        }
        if (this.who != null) {
            ret.append(this.who).append(' ');
        }
        if (this.when != null) {
            ret.append("at (").append(this.when).append(") ");
        }
        if (where != null) {
            ret.append("in ").append(where);
        }
        if (this.type == E_MessageType.ERROR) {
            ret.append("-> ");
        }
        if (this.what != null) {
            ret.append(this.what);
        }
        if (this.why != null) {
            ret.appendNewLine();
            ret.append("        ==> ").append(this.why);
        }
        if (this.how != null) {
            ret.appendNewLine();
            ret.append("        ==> ").append(this.how);
        }
        return ret.toString();
    }

    public boolean setReporter(Object reporter) {
        if (reporter != null) {
            this.reporter = reporter;
            return true;
        }
        return false;
    }

    public StrBuilder getHow() {
        return this.how;
    }

    public Object getReporter() {
        return this.reporter;
    }

    public E_MessageType getType() {
        return this.type;
    }

    public StrBuilder getWhat() {
        return this.what;
    }

    public Object getWhen() {
        return this.when;
    }

    public Object getWhereLocation() {
        return this.whereLocation;
    }

    public int getWhereLine() {
        return this.whereLine;
    }

    public int getWhereColumn() {
        return this.whereColumn;
    }

    public Object getWho() {
        return this.who;
    }

    public StrBuilder getWhy() {
        return this.why;
    }

    public Message5WH changeType(E_MessageType type) {
        this.type = type;
        return this;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, this.getStyle()).append("who       ", this.who, false).append("who       ", this.who).append("what      ", (Object)this.what).append("whereLoc  ", this.whereLocation).append("whereLine ", this.whereLine).append("whereCol  ", this.whereColumn).append("when      ", this.when, false).append("when      ", this.when).append("why       ", (Object)this.why).append("how       ", (Object)this.how).append("type      ", (Object)this.type).append("reporter  ", this.reporter, false).append("reporter  ", this.reporter).toString();
    }
}

