/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.base.shell;

import de.vandermeer.skb.base.shell.CommandInterpreter;
import de.vandermeer.skb.base.shell.SkbShellCommand;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class AbstractCommandInterpreter
implements CommandInterpreter {
    private final Map<String, SkbShellCommand> commands = new TreeMap<String, SkbShellCommand>();

    public AbstractCommandInterpreter() {
    }

    public AbstractCommandInterpreter(SkbShellCommand command) {
        this();
        if (command != null) {
            this.commands.put(command.getCommand(), command);
        }
    }

    public AbstractCommandInterpreter(SkbShellCommand[] commands) {
        this();
        if (commands != null) {
            for (SkbShellCommand command : commands) {
                if (command == null) continue;
                this.commands.put(command.getCommand(), command);
            }
        }
    }

    public AbstractCommandInterpreter(Collection<SkbShellCommand> commands) {
        this();
        if (commands != null) {
            for (SkbShellCommand command : commands) {
                if (command == null) continue;
                this.commands.put(command.getCommand(), command);
            }
        }
    }

    @Override
    public Set<String> getCommandStrings() {
        return this.commands.keySet();
    }

    @Override
    public Map<String, SkbShellCommand> getCommands() {
        return this.commands;
    }
}

