/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.base.shell;

import de.vandermeer.skb.base.console.NonBlockingReader;
import de.vandermeer.skb.base.managers.MessageMgr;
import de.vandermeer.skb.base.managers.MessageMgrBuilder;
import de.vandermeer.skb.base.managers.MessageRenderer;
import de.vandermeer.skb.base.message.E_MessageType;
import de.vandermeer.skb.base.shell.CommandInterpreter;
import de.vandermeer.skb.base.shell.SkbShell;
import de.vandermeer.skb.interfaces.MessageConsole;
import de.vandermeer.skb.interfaces.categories.has.HasPrompt;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public class AbstractShell
implements SkbShell {
    protected final Map<String, CommandInterpreter> commandMap;
    protected final MessageMgr mm;
    protected boolean isRunning = true;
    protected int exitStatus;
    protected Thread thread;
    protected Object notify;
    protected String id;
    protected final List<String> history;

    protected AbstractShell() {
        this(null, null, true);
    }

    protected AbstractShell(MessageRenderer renderer) {
        this(null, renderer, true);
    }

    protected AbstractShell(MessageRenderer renderer, boolean useConsole) {
        this(null, renderer, useConsole);
    }

    protected AbstractShell(String id) {
        this(id, null, true);
    }

    protected AbstractShell(String id, boolean useConsole) {
        this(id, null, useConsole);
    }

    protected AbstractShell(String id, MessageRenderer renderer) {
        this(id, renderer, true);
    }

    protected AbstractShell(String id, MessageRenderer renderer, boolean useConsole) {
        MessageConsole.PRINT_MESSAGES = useConsole;
        this.commandMap = new HashMap<String, CommandInterpreter>();
        this.id = id != null ? id : "skbsh";
        MessageMgrBuilder mmb = new MessageMgrBuilder(this.getPromptName());
        mmb.setHandler(E_MessageType.ERROR);
        mmb.setHandler(E_MessageType.WARNING);
        mmb.setHandler(E_MessageType.INFO);
        mmb.enableMessageCollection();
        this.mm = mmb.build();
        if (this.mm == null) {
            throw new IllegalArgumentException("could not create MM, possibly wrong STG");
        }
        this.mm.setRenderer(renderer);
        this.history = new ArrayList<String>(20);
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public Map<String, CommandInterpreter> getCommandMap() {
        return this.commandMap;
    }

    @Override
    public Set<String> getCommands() {
        TreeSet<String> ret = new TreeSet<String>();
        ret.addAll(this.commandMap.keySet());
        return ret;
    }

    @Override
    public Thread start(Object notify) {
        if (this.thread == null) {
            this.notify = notify;
            this.thread = new Thread(){

                @Override
                public void run() {
                    AbstractShell.this.runShell();
                }
            };
            this.thread.start();
            return this.thread;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this.thread != null) {
            this.notify = null;
            Thread thread = this.thread;
            synchronized (thread) {
                this.thread.interrupt();
            }
            this.thread = null;
        }
        this.isRunning = false;
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public int getExitStatus() {
        return this.exitStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int runShell(BufferedReader reader) {
        BufferedReader sysin = reader;
        if (sysin == null) {
            MessageConsole.conError((String)"{}: could not load standard input device (stdin)", (Object[])new Object[]{this.getPromptName()});
            return -1;
        }
        this.isRunning = true;
        String in = "";
        while (this.isRunning()) {
            this.exitStatus = -99;
            try {
                if ((in != null || "".equals(in) || "\n".equals(in)) && MessageConsole.PRINT_MESSAGES) {
                    System.out.print(this.prompt());
                }
                if (!StringUtils.isBlank((CharSequence)(in = sysin.readLine()))) {
                    this.history.add(in);
                }
                this.exitStatus = this.parseLine(in);
                if (this.exitStatus != -2) continue;
                this.isRunning = false;
            }
            catch (IOException ignore) {
                ignore.printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.notify != null) {
            Object object = this.notify;
            synchronized (object) {
                this.notify.notify();
            }
        }
        this.isRunning = false;
        return this.exitStatus;
    }

    @Override
    public int runShell() {
        BufferedReader sysin = NonBlockingReader.getNbReader(this.getID(), 1, 500, (HasPrompt)this);
        return this.runShell(sysin);
    }

    @Override
    public MessageMgr getMessageManager() {
        return this.mm;
    }

    @Override
    public List<String> getCommandHistory() {
        return this.history;
    }
}

