/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.base.shell;

import de.vandermeer.skb.base.shell.SkbShellArgument;
import de.vandermeer.skb.base.shell.SkbShellArgumentType;
import de.vandermeer.skb.interfaces.FormattingTupleWrapper;
import org.apache.commons.lang3.ArrayUtils;

public class AbstractShellArgument
implements SkbShellArgument {
    private final String argument;
    private final boolean isOptional;
    private final SkbShellArgumentType type;
    private final String description;
    private final String addedHelp;
    private final Object[] valueSet;

    AbstractShellArgument(String argument, boolean isOptional, SkbShellArgumentType type, Object[] valueSet, String description, String addedHelp) {
        if (argument == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        if (description == null) {
            throw new IllegalArgumentException("description cannot be null");
        }
        this.argument = argument;
        this.isOptional = isOptional;
        this.type = type;
        this.valueSet = valueSet;
        this.description = description;
        this.addedHelp = addedHelp;
    }

    @Override
    public String getKey() {
        return this.argument;
    }

    @Override
    public SkbShellArgumentType getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public String addedHelp() {
        return this.addedHelp;
    }

    @Override
    public boolean isOptional() {
        return this.isOptional;
    }

    public String toString() {
        if (this.valueSet == null) {
            FormattingTupleWrapper ftw = FormattingTupleWrapper.create((String)"{}:{}", (Object[])new Object[]{this.getKey(), this.getType().name()});
            return ftw.getMessage();
        }
        FormattingTupleWrapper ftw = FormattingTupleWrapper.create((String)"{}:{}:{}", (Object[])new Object[]{this.getKey(), this.getType().name(), ArrayUtils.toString((Object)this.valueSet())});
        return ftw.getMessage();
    }

    @Override
    public Object[] valueSet() {
        return this.valueSet;
    }
}

