/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.base.shell;

import de.vandermeer.skb.base.shell.SkbShellArgument;
import de.vandermeer.skb.base.shell.SkbShellCommand;
import de.vandermeer.skb.base.shell.SkbShellCommandCategory;
import de.vandermeer.skb.interfaces.FormattingTupleWrapper;
import java.util.TreeMap;

public class AbstractShellCommand
implements SkbShellCommand {
    private final String command;
    private final SkbShellCommandCategory category;
    private final SkbShellArgument[] arguments;
    private final String description;
    private final String addedHelp;

    AbstractShellCommand(String command, SkbShellArgument[] arguments, SkbShellCommandCategory category, String description, String addedHelp) {
        if (command == null) {
            throw new IllegalArgumentException("command cannot be null");
        }
        if (description == null) {
            throw new IllegalArgumentException("description cannot be null");
        }
        this.command = command;
        this.arguments = arguments;
        this.category = category;
        this.description = description;
        this.addedHelp = addedHelp;
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    public SkbShellArgument[] getArguments() {
        return this.arguments;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public SkbShellCommandCategory getCategory() {
        return this.category;
    }

    @Override
    public String addedHelp() {
        return this.addedHelp;
    }

    public String toString() {
        TreeMap<String, SkbShellArgument> args = new TreeMap<String, SkbShellArgument>();
        for (SkbShellArgument arg : this.getArguments()) {
            args.put(arg.getKey(), arg);
        }
        FormattingTupleWrapper ftw = FormattingTupleWrapper.create((String)"<{}> cat <{}> args {} descr <{}>", (Object[])new Object[]{this.getCommand(), this.getCategory(), args.values(), this.getDescription()});
        return ftw.getMessage();
    }
}

