/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.base.shell;

import de.vandermeer.skb.base.managers.MessageMgr;
import de.vandermeer.skb.base.shell.Ci_Help;
import de.vandermeer.skb.base.shell.CommandInterpreter;
import de.vandermeer.skb.base.shell.LineParser;
import de.vandermeer.skb.base.shell.SkbShell;
import de.vandermeer.skb.base.shell.SkbShellArgument;
import de.vandermeer.skb.base.shell.SkbShellCommand;
import de.vandermeer.skb.interfaces.MessageConsole;
import de.vandermeer.skb.interfaces.messagesets.IsInfoSetFT;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.text.StrBuilder;

public class Ci_HelpStg
extends Ci_Help {
    public Ci_HelpStg(SkbShell skbShell) {
        super(skbShell);
    }

    @Override
    public int interpretCommand(String command, LineParser lp, MessageMgr mm) {
        int ret = super.interpretCommand(command, lp, mm);
        if (ret != 0) {
            return ret;
        }
        IsInfoSetFT info = IsInfoSetFT.create();
        String toHelp = lp.getArgs();
        if (toHelp == null) {
            this.generalHelp(info);
        } else {
            this.specificHelp(info, toHelp);
        }
        info.addInfo("");
        MessageConsole.conInfo((String)info.render());
        return 0;
    }

    protected void specificHelp(IsInfoSetFT info, String toHelp) {
        if (this.skbShell.getCommandMap().containsKey(toHelp)) {
            SkbShellCommand ssc = this.skbShell.getCommandMap().get(toHelp).getCommands().get(toHelp);
            TreeMap<String, SkbShellArgument> args = new TreeMap<String, SkbShellArgument>();
            if (ssc.getArguments() != null) {
                for (SkbShellArgument ssa : ssc.getArguments()) {
                    if (ssa.isOptional()) {
                        args.put("[" + ssa.getKey() + "]", ssa);
                        continue;
                    }
                    args.put("<" + ssa.getKey() + ">", ssa);
                }
            }
            info.addInfo("{} {} -- {}", new Object[]{ssc.getCommand(), new StrBuilder().appendWithSeparators(args.keySet(), ", "), ssc.getDescription()});
            for (SkbShellArgument ssa : args.values()) {
                if (ssa.valueSet() != null && ssa.addedHelp() != null) {
                    info.addInfo(" -- <{}> of type {} - {} - {} - value set {}", new Object[]{ssa.getKey(), ssa.getType().name(), ssa.getDescription(), ssa.addedHelp(), ArrayUtils.toString((Object)ssa.valueSet())});
                    continue;
                }
                if (ssa.valueSet() != null && ssa.addedHelp() == null) {
                    info.addInfo(" -- <{}> of type {} - {} - value set {}", new Object[]{ssa.getKey(), ssa.getType().name(), ssa.getDescription(), ArrayUtils.toString((Object)ssa.valueSet())});
                    continue;
                }
                if (ssa.valueSet() == null && ssa.addedHelp() != null) {
                    info.addInfo(" -- <{}> of type {} - {} - {}", new Object[]{ssa.getKey(), ssa.getType().name(), ssa.getDescription(), ssa.addedHelp()});
                    continue;
                }
                info.addInfo(" -- <{}> of type {} - {}", new Object[]{ssa.getKey(), ssa.getType().name(), ssa.getDescription()});
            }
            if (ssc.addedHelp() != null) {
                info.addInfo("{}", new Object[]{ssc.addedHelp()});
            }
        } else {
            info.addInfo("");
            info.addInfo("{}: no command {} found for help, try 'help' to see all available commands", new Object[]{this.skbShell.getPromptName(), toHelp});
        }
    }

    protected void generalHelp(IsInfoSetFT info) {
        String defKey = "__standard";
        TreeMap cat2Cmd = new TreeMap();
        for (CommandInterpreter ci : this.skbShell.getCommandMap().values()) {
            for (SkbShellCommand ssc : ci.getCommands().values()) {
                String cat = defKey;
                if (ssc.getCategory() != null) {
                    cat = ssc.getCategory().getCategory();
                }
                if (!cat2Cmd.containsKey(cat)) {
                    cat2Cmd.put(cat, new TreeMap());
                }
                ((TreeMap)cat2Cmd.get(cat)).put(ssc.getCommand(), ssc);
            }
        }
        info.addInfo("");
        info.addInfo("{} {}", new Object[]{this.skbShell.getDisplayName(), this.skbShell.getDescription()});
        info.addInfo("");
        Iterator<CommandInterpreter> iterator = cat2Cmd.keySet().iterator();
        while (iterator.hasNext()) {
            String cat;
            String catDescr = cat = (String)((Object)iterator.next());
            if (defKey.equals(cat)) {
                catDescr = "standard commands";
            }
            info.addInfo("- {}: {}", new Object[]{catDescr, ((TreeMap)cat2Cmd.get(cat)).keySet()});
        }
        info.addInfo("  try: 'help <command>' for more details");
    }
}

