/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.base.shell;

import de.vandermeer.asciitable.AT_ColumnWidthCalculator;
import de.vandermeer.asciitable.AT_Renderer;
import de.vandermeer.asciitable.AsciiTable;
import de.vandermeer.asciitable.CWC_FixedWidth;
import de.vandermeer.asciithemes.TA_Grid;
import de.vandermeer.asciithemes.a7.A7_Grids;
import de.vandermeer.skb.base.managers.MessageMgr;
import de.vandermeer.skb.base.shell.Ci_Help;
import de.vandermeer.skb.base.shell.CommandInterpreter;
import de.vandermeer.skb.base.shell.LineParser;
import de.vandermeer.skb.base.shell.SkbShell;
import de.vandermeer.skb.base.shell.SkbShellArgument;
import de.vandermeer.skb.base.shell.SkbShellCommand;
import de.vandermeer.skb.interfaces.FormattingTupleWrapper;
import de.vandermeer.skb.interfaces.MessageConsole;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.text.StrBuilder;

public class Ci_HelpTable
extends Ci_Help {
    protected TA_Grid grid;
    protected AT_ColumnWidthCalculator cwc;

    public Ci_HelpTable(SkbShell skbShell) {
        this(skbShell, null);
    }

    public Ci_HelpTable(SkbShell skbShell, TA_Grid grid) {
        super(skbShell);
        this.grid = grid == null ? A7_Grids.minusBarPlus() : grid;
        this.cwc = new CWC_FixedWidth().add(15).add(70);
    }

    public Ci_HelpTable setWidth(AT_ColumnWidthCalculator cwc) {
        if (cwc != null) {
            this.cwc = cwc;
        }
        return this;
    }

    @Override
    public int interpretCommand(String command, LineParser lp, MessageMgr mm) {
        int ret = super.interpretCommand(command, lp, mm);
        if (ret != 0) {
            return ret;
        }
        AsciiTable at = new AsciiTable();
        at.getContext().setGrid(this.grid);
        at.addStrongRule();
        String toHelp = lp.getArgs();
        if (toHelp == null) {
            this.generalHelp(at);
        } else {
            this.specificHelp(at, toHelp);
        }
        at.addStrongRule();
        MessageConsole.conInfo((String)"");
        AT_Renderer rend = AT_Renderer.create().setCWC(this.cwc);
        at.setRenderer(rend);
        MessageConsole.conInfo((String)at.render());
        return 0;
    }

    protected void specificHelp(AsciiTable at, String toHelp) {
        if (this.skbShell.getCommandMap().containsKey(toHelp)) {
            SkbShellCommand ssc = this.skbShell.getCommandMap().get(toHelp).getCommands().get(toHelp);
            TreeMap<String, SkbShellArgument> args = new TreeMap<String, SkbShellArgument>();
            if (ssc.getArguments() != null) {
                for (SkbShellArgument ssa : ssc.getArguments()) {
                    if (ssa.isOptional()) {
                        args.put("[" + ssa.getKey() + "]", ssa);
                        continue;
                    }
                    args.put("<" + ssa.getKey() + ">", ssa);
                }
            }
            at.addRow(new Object[]{ssc.getCommand(), new StrBuilder().appendWithSeparators(args.keySet(), ", ")});
            at.addRow(new Object[]{"", ssc.getDescription()});
            for (SkbShellArgument ssa : args.values()) {
                if (ssa.valueSet() != null && ssa.addedHelp() != null) {
                    at.addRow(new Object[]{"", FormattingTupleWrapper.create((String)" -- <{}> of type {} - {} - {} - value set {}", (Object[])new Object[]{ssa.getKey(), ssa.getType().name(), ssa.getDescription(), ssa.addedHelp(), ArrayUtils.toString((Object)ssa.valueSet())})});
                    continue;
                }
                if (ssa.valueSet() != null && ssa.addedHelp() == null) {
                    at.addRow(new Object[]{"", FormattingTupleWrapper.create((String)" -- <{}> of type {} - {} - value set {}", (Object[])new Object[]{ssa.getKey(), ssa.getType().name(), ssa.getDescription(), ArrayUtils.toString((Object)ssa.valueSet())})});
                    continue;
                }
                if (ssa.valueSet() == null && ssa.addedHelp() != null) {
                    at.addRow(new Object[]{"", FormattingTupleWrapper.create((String)" -- <{}> of type {} - {} - {}", (Object[])new Object[]{ssa.getKey(), ssa.getType().name(), ssa.getDescription(), ssa.addedHelp()})});
                    continue;
                }
                at.addRow(new Object[]{"", FormattingTupleWrapper.create((String)" -- <{}> of type {} - {}", (Object[])new Object[]{ssa.getKey(), ssa.getType().name(), ssa.getDescription()})});
            }
            if (ssc.addedHelp() != null) {
                at.addRow(new Object[]{"", ssc.addedHelp()});
            }
        } else {
            MessageConsole.conInfo((String)"");
            MessageConsole.conInfo((String)"{}: no command {} found for help, try 'help' to see all available commands", (Object[])new Object[]{this.skbShell.getPromptName(), toHelp});
        }
    }

    protected void generalHelp(AsciiTable at) {
        String defKey = "__standard";
        TreeMap cat2Cmd = new TreeMap();
        for (CommandInterpreter ci : this.skbShell.getCommandMap().values()) {
            for (SkbShellCommand ssc : ci.getCommands().values()) {
                String cat = defKey;
                if (ssc.getCategory() != null) {
                    cat = ssc.getCategory().getCategory();
                }
                if (!cat2Cmd.containsKey(cat)) {
                    cat2Cmd.put(cat, new TreeMap());
                }
                ((TreeMap)cat2Cmd.get(cat)).put(ssc.getCommand(), ssc);
            }
        }
        at.addRow(new Object[]{null, this.skbShell.getDisplayName() + "-" + this.skbShell.getDescription()});
        at.addRule();
        Iterator<CommandInterpreter> iterator = cat2Cmd.keySet().iterator();
        while (iterator.hasNext()) {
            String cat;
            String catDescr = cat = (String)((Object)iterator.next());
            if (defKey.equals(cat)) {
                catDescr = "standard commands";
            }
            at.addRow(new Object[]{catDescr, new StrBuilder().appendWithSeparators(((TreeMap)cat2Cmd.get(cat)).keySet(), ", ")});
            at.addRule();
        }
        at.addRow(new Object[]{null, "try: 'help <command>' for more details"});
    }
}

