/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.base.shell;

import de.vandermeer.skb.base.managers.MessageMgr;
import de.vandermeer.skb.base.shell.AbstractCommandInterpreter;
import de.vandermeer.skb.base.shell.LineParser;
import de.vandermeer.skb.base.shell.SkbShell;
import de.vandermeer.skb.base.shell.SkbShellCommand;
import de.vandermeer.skb.base.shell.SkbShellFactory;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class Ci_History
extends AbstractCommandInterpreter {
    public static final SkbShellCommand HISTORY = SkbShellFactory.newCommand("history", SkbShellFactory.SIMPLE_COMMANDS, "prints shell history or recalls a command", null);
    public static final SkbShellCommand HISTORY_EM = SkbShellFactory.newCommand("!", SkbShellFactory.SIMPLE_COMMANDS, "prints shell history or recalls a command", null);
    protected final SkbShell skbsh;

    public Ci_History(SkbShell skbsh) {
        super(new SkbShellCommand[]{HISTORY, HISTORY_EM});
        if (skbsh == null) {
            throw new IllegalArgumentException("shell cannot be null");
        }
        this.skbsh = skbsh;
    }

    @Override
    public int interpretCommand(String command, LineParser lp, MessageMgr mm) {
        if (StringUtils.isBlank((CharSequence)command) || lp == null) {
            return -3;
        }
        if (!HISTORY.getCommand().equals(command) && !HISTORY_EM.getCommand().equals(command)) {
            return -1;
        }
        List<String> history = this.skbsh.getCommandHistory();
        history.remove(history.size() - 1);
        if (StringUtils.isBlank((CharSequence)lp.setTokenPosition(1).getArgs())) {
            for (int i = 0; i < this.skbsh.getCommandHistory().size(); ++i) {
                mm.report((Object)MessageMgr.createInfoMessage("! {} {}", i, this.skbsh.getCommandHistory().get(i)));
            }
        } else {
            int position = NumberUtils.toInt((String)lp.setTokenPosition(1).getArgs(), (int)-1);
            if (position != -1) {
                this.skbsh.parseLine(this.skbsh.getCommandHistory().get(position));
            } else {
                mm.report((Object)MessageMgr.createErrorMessage("history, position <{}> not found", lp.setTokenPosition(1).getArgs()));
            }
        }
        return 0;
    }
}

