/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.base.shell;

import de.vandermeer.skb.base.info.CommonsDirectoryWalker;
import de.vandermeer.skb.base.info.FileSource;
import de.vandermeer.skb.base.info.FileSourceList;
import de.vandermeer.skb.base.info.StringFileLoader;
import de.vandermeer.skb.base.managers.MessageMgr;
import de.vandermeer.skb.base.shell.AbstractCommandInterpreter;
import de.vandermeer.skb.base.shell.LineParser;
import de.vandermeer.skb.base.shell.SkbShell;
import de.vandermeer.skb.base.shell.SkbShellArgument;
import de.vandermeer.skb.base.shell.SkbShellArgumentType;
import de.vandermeer.skb.base.shell.SkbShellCommand;
import de.vandermeer.skb.base.shell.SkbShellFactory;
import de.vandermeer.skb.interfaces.MessageConsole;
import java.util.Iterator;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.StringUtils;

public class Ci_ScRun
extends AbstractCommandInterpreter {
    protected String lastScript;
    protected boolean printProgress = true;
    protected final SkbShell skbShell;
    public static String SCRIPT_FILE_EXTENSION = "ssc";
    public static final SkbShellArgument ARG_SCRIPT_RUN = SkbShellFactory.newArgument("script", false, SkbShellArgumentType.String, null, "name (filename) of a script", "script files use the extension " + SCRIPT_FILE_EXTENSION + ", filename can be w/o extension");
    public static final SkbShellArgument ARG_SCRIPT_INFO = SkbShellFactory.newArgument("script", false, SkbShellArgumentType.String, null, "name (filename) of a script", "the information provided is taken from a line in the script that starts with //**");
    public static final SkbShellArgument ARG_DIRECTORY = SkbShellFactory.newArgument("directory", false, SkbShellArgumentType.String, null, "directory to search in, can be in file system or class path", null);
    public static final SkbShellCommand SC_RUN = SkbShellFactory.newCommand("scrun", ARG_SCRIPT_RUN, SkbShellFactory.SIMPLE_COMMANDS, "runs a <script> with shell commands", null);
    public static final SkbShellCommand SC_INFO = SkbShellFactory.newCommand("scinfo", ARG_SCRIPT_INFO, SkbShellFactory.SIMPLE_COMMANDS, "provides information about <script> file if available", null);
    public static final SkbShellCommand SC_LS = SkbShellFactory.newCommand("scls", ARG_DIRECTORY, SkbShellFactory.SIMPLE_COMMANDS, "lists available script files", null);

    public Ci_ScRun(SkbShell skbShell) {
        this(true, skbShell);
    }

    public Ci_ScRun(boolean printProgress, SkbShell skbShell) {
        super(new SkbShellCommand[]{SC_RUN, SC_INFO, SC_LS});
        this.printProgress = printProgress;
        this.skbShell = skbShell;
    }

    @Override
    public int interpretCommand(String command, LineParser lp, MessageMgr mm) {
        if (StringUtils.isBlank((CharSequence)command) || lp == null) {
            return -3;
        }
        if (!(SC_RUN.getCommand().equals(command) || SC_INFO.getCommand().equals(command) || SC_LS.getCommand().equals(command))) {
            return -1;
        }
        if (SC_RUN.getCommand().equals(command)) {
            return this.interpretRun(lp, mm);
        }
        if (SC_LS.getCommand().equals(command)) {
            return this.interpretLs(lp, mm);
        }
        if (SC_INFO.getCommand().equals(command)) {
            return this.interpretInfo(lp, mm);
        }
        return 0;
    }

    protected int interpretInfo(LineParser lp, MessageMgr mm) {
        String fileName = this.getFileName(lp);
        String content = this.getContent(fileName, mm);
        if (content == null) {
            return 1;
        }
        String[] lines = StringUtils.split((String)content, (String)"\n");
        String info = null;
        for (String s : lines) {
            if (!s.startsWith("//**")) continue;
            info = StringUtils.substringAfter((String)s, (String)"//**");
            break;
        }
        if (info != null) {
            mm.report((Object)MessageMgr.createInfoMessage("script {} - info: {}", fileName, info));
        }
        return 0;
    }

    protected int interpretLs(LineParser lp, MessageMgr mm) {
        String directory = lp.getArgs();
        WildcardFileFilter fileFilter = new WildcardFileFilter(new String[]{"*.ssc"});
        CommonsDirectoryWalker dl = new CommonsDirectoryWalker(directory, DirectoryFileFilter.INSTANCE, (IOFileFilter)fileFilter);
        if (dl.getLoadErrors().hasErrors()) {
            mm.report(dl.getLoadErrors());
            return 1;
        }
        FileSourceList fsl = dl.load();
        if (dl.getLoadErrors().hasErrors()) {
            mm.report(dl.getLoadErrors());
            return 1;
        }
        Iterator iterator = fsl.getSource().iterator();
        while (iterator.hasNext()) {
            FileSource fs = (FileSource)iterator.next();
            mm.report((Object)MessageMgr.createInfoMessage("script file - dir <{}> file <{}>", directory, fs.getBaseFileName()));
        }
        return 0;
    }

    protected int interpretRun(LineParser lp, MessageMgr mm) {
        String fileName = this.getFileName(lp);
        String content = this.getContent(fileName, mm);
        if (content == null) {
            return 1;
        }
        mm.report((Object)MessageMgr.createInfoMessage("", new Object[0]));
        mm.report((Object)MessageMgr.createInfoMessage("running file {}", fileName));
        for (String s : StringUtils.split((String)content, (char)'\n')) {
            if (this.printProgress && MessageConsole.PRINT_MESSAGES) {
                System.out.print(".");
            }
            this.skbShell.parseLine(s);
        }
        this.lastScript = fileName;
        return 0;
    }

    protected String getFileName(LineParser lp) {
        String fileName = lp.getArgs();
        if (fileName == null) {
            fileName = this.lastScript;
        } else if (!fileName.endsWith("." + SCRIPT_FILE_EXTENSION)) {
            fileName = fileName + "." + SCRIPT_FILE_EXTENSION;
        }
        return fileName;
    }

    protected String getContent(String fileName, MessageMgr mm) {
        StringFileLoader sfl = new StringFileLoader(fileName);
        if (sfl.getLoadErrors().hasErrors()) {
            mm.report(sfl.getLoadErrors());
            return null;
        }
        String content = sfl.load();
        if (sfl.getLoadErrors().hasErrors()) {
            mm.report(sfl.getLoadErrors());
            return null;
        }
        if (content == null) {
            mm.report((Object)MessageMgr.createErrorMessage("run: unexpected problem with run script, content was null", new Object[0]));
            return null;
        }
        return content;
    }
}

