/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.base.shell;

import de.vandermeer.skb.base.managers.MessageMgr;
import de.vandermeer.skb.base.shell.AbstractCommandInterpreter;
import de.vandermeer.skb.base.shell.LineParser;
import de.vandermeer.skb.base.shell.SkbShellArgument;
import de.vandermeer.skb.base.shell.SkbShellArgumentType;
import de.vandermeer.skb.base.shell.SkbShellCommand;
import de.vandermeer.skb.base.shell.SkbShellFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class Ci_Wait
extends AbstractCommandInterpreter {
    public static final SkbShellArgument ARG_TIME = SkbShellFactory.newArgument("time", false, SkbShellArgumentType.Integer, null, "wait time in milliseconds", null);
    public static final SkbShellCommand WAIT = SkbShellFactory.newCommand("wait", ARG_TIME, SkbShellFactory.SIMPLE_COMMANDS, "shell waits for <time> milliseconds before accepting the next command", null);

    public Ci_Wait() {
        super(WAIT);
    }

    @Override
    public int interpretCommand(String command, LineParser lp, MessageMgr mm) {
        if (StringUtils.isBlank((CharSequence)command) || lp == null) {
            return -3;
        }
        if (!WAIT.getCommand().equals(command)) {
            return -1;
        }
        int sleep = NumberUtils.toInt((String)lp.setTokenPosition(1).getArgs(), (int)-1);
        if (sleep == -1) {
            mm.report((Object)MessageMgr.createErrorMessage("wait with no number argument: {}", lp.setTokenPosition(1).getArgs()));
        } else {
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                mm.report((Object)MessageMgr.createErrorMessage("interrupted in wait {}", e.getMessage()));
            }
        }
        return 0;
    }
}

