/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.base.shell;

import de.vandermeer.skb.base.shell.SkbShellArgument;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class LineParser {
    protected String line;
    protected int tokenPosition = 1;

    public LineParser(String line) {
        this.line = StringUtils.trim((String)line);
    }

    public LineParser setTokenPosition(int pos) {
        this.tokenPosition = pos;
        return this;
    }

    public String getLine() {
        return this.line;
    }

    public String getToken() {
        String[] ar;
        if (this.tokenPosition > 0 && (ar = StringUtils.split((String)this.line, null, (int)(this.tokenPosition + 1))) != null && ar.length > this.tokenPosition - 1) {
            return StringUtils.trim((String)ar[this.tokenPosition - 1]);
        }
        return null;
    }

    public String getArgs() {
        int count = this.tokenPosition == 0 ? 1 : this.tokenPosition + 1;
        String[] ar = StringUtils.split((String)this.line, null, (int)count);
        if (ar != null && ar.length > this.tokenPosition) {
            return StringUtils.trim((String)ar[this.tokenPosition]);
        }
        return null;
    }

    public ArrayList<String> getArgList() {
        ArrayList<String> ret = new ArrayList<String>();
        String[] ar = StringUtils.split((String)this.getArgs());
        if (ar != null) {
            for (String s : ar) {
                ret.add(StringUtils.trim((String)s));
            }
        }
        return ret;
    }

    public Map<String, String> getArgMap() {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        String[] ar = StringUtils.split((String)this.getArgs(), (char)',');
        if (ar != null) {
            for (String s : ar) {
                String[] kv = StringUtils.split((String)s, (String)":", (int)2);
                if (kv == null || kv.length != 2) continue;
                ret.put(StringUtils.trim((String)kv[0]), StringUtils.trim((String)kv[1]));
            }
        }
        return ret;
    }

    public Map<SkbShellArgument, Object> getArgMap(SkbShellArgument[] arguments) {
        LinkedHashMap<SkbShellArgument, Object> ret = new LinkedHashMap<SkbShellArgument, Object>();
        if (arguments != null) {
            for (Map.Entry<String, String> entry : this.getArgMap().entrySet()) {
                block9: for (SkbShellArgument ssa : arguments) {
                    if (!ssa.getKey().equals(entry.getKey())) continue;
                    switch (ssa.getType()) {
                        case Boolean: {
                            ret.put(ssa, Boolean.valueOf(entry.getValue()));
                            continue block9;
                        }
                        case Double: {
                            ret.put(ssa, Double.valueOf(entry.getValue()));
                            continue block9;
                        }
                        case Integer: {
                            ret.put(ssa, Integer.valueOf(entry.getValue()));
                            continue block9;
                        }
                        case String: {
                            ret.put(ssa, entry.getValue());
                            continue block9;
                        }
                        case ListString: {
                            String[] ar = StringUtils.split((String)entry.getValue(), (char)';');
                            if (ar == null) continue block9;
                            ArrayList<String> val = new ArrayList<String>();
                            for (String s : ar) {
                                val.add(s);
                            }
                            ret.put(ssa, val);
                            continue block9;
                        }
                        case ListInteger: {
                            String[] arInt = StringUtils.split((String)entry.getValue(), (char)';');
                            if (arInt == null) continue block9;
                            ArrayList<Integer> valInt = new ArrayList<Integer>();
                            for (String s : arInt) {
                                valInt.add(Integer.valueOf(s));
                            }
                            ret.put(ssa, valInt);
                            continue block9;
                        }
                        default: {
                            System.err.println("parser.getArgMap --> argument type not yet supported: " + (Object)((Object)ssa.getType()));
                        }
                    }
                }
            }
        }
        return ret;
    }
}

