/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.base.shell;

import de.vandermeer.skb.base.managers.MessageMgr;
import de.vandermeer.skb.base.shell.CommandInterpreter;
import de.vandermeer.skb.base.shell.LineParser;
import de.vandermeer.skb.interfaces.categories.has.HasPrompt;
import java.io.BufferedReader;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrBuilder;

public interface SkbShell
extends HasPrompt {
    default public boolean addCommandInterpreter(CommandInterpreter interpreter) {
        if (interpreter == null || interpreter.getCommands() == null) {
            return false;
        }
        for (String cmd : interpreter.getCommandStrings()) {
            this.getCommandMap().put(cmd, interpreter);
        }
        return true;
    }

    default public void addCommandInterpreter(CommandInterpreter[] interpreters) {
        if (interpreters == null) {
            return;
        }
        for (CommandInterpreter ci : interpreters) {
            if (ci == null || ci.getCommands() == null) continue;
            for (String cmd : ci.getCommandStrings()) {
                this.getCommandMap().put(cmd, ci);
            }
        }
    }

    default public void addCommandInterpreter(Collection<CommandInterpreter> interpreters) {
        if (interpreters == null) {
            return;
        }
        for (CommandInterpreter ci : interpreters) {
            if (ci == null || ci.getCommands() == null) continue;
            for (String cmd : ci.getCommandStrings()) {
                this.getCommandMap().put(cmd, ci);
            }
        }
    }

    default public String getDescription() {
        return "skb standard command shell";
    }

    default public String getDisplayName() {
        return "SKB Shell";
    }

    public String getID();

    default public String getPromptName() {
        return this.getID();
    }

    public Map<String, CommandInterpreter> getCommandMap();

    public Set<String> getCommands();

    default public StrBuilder prompt() {
        StrBuilder ret = new StrBuilder(30);
        ret.append('[').append(this.getPromptName()).append("]> ");
        return ret;
    }

    default public int parseLine(String in) {
        if (StringUtils.isBlank((CharSequence)in) || in.startsWith("//") || in.startsWith("#")) {
            return 0;
        }
        this.getMessageManager().clear();
        int ret = 0;
        LineParser lp = new LineParser(in);
        String command = lp.getToken();
        if (this.getCommandMap().containsKey(command)) {
            ret = this.getCommandMap().get(command).interpretCommand(command, lp, this.getMessageManager());
        } else {
            this.getMessageManager().report((Object)MessageMgr.createErrorMessage("comand <{}> not found in shell, taken from line: <{}>", command, in));
            ret = -1;
        }
        return ret;
    }

    public Thread start(Object var1);

    public void stop();

    public boolean isRunning();

    public int getExitStatus();

    public int runShell();

    public int runShell(BufferedReader var1);

    public MessageMgr getMessageManager();

    public List<String> getCommandHistory();
}

