/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.base.shell;

import de.vandermeer.skb.base.managers.MessageRenderer;
import de.vandermeer.skb.base.shell.AbstractCategory;
import de.vandermeer.skb.base.shell.AbstractShell;
import de.vandermeer.skb.base.shell.AbstractShellArgument;
import de.vandermeer.skb.base.shell.AbstractShellCommand;
import de.vandermeer.skb.base.shell.SkbShell;
import de.vandermeer.skb.base.shell.SkbShellArgument;
import de.vandermeer.skb.base.shell.SkbShellArgumentType;
import de.vandermeer.skb.base.shell.SkbShellCommand;
import de.vandermeer.skb.base.shell.SkbShellCommandCategory;
import java.util.HashSet;

public class SkbShellFactory {
    public static SkbShellCommandCategory SIMPLE_COMMANDS = SkbShellFactory.newCategory("Simple", "commands with 0 or 1 argument, no argument id required");

    public static SkbShell newShell() {
        return SkbShellFactory.newShell(null, null, true);
    }

    public static SkbShell newShell(MessageRenderer renderer) {
        return SkbShellFactory.newShell(null, renderer, true);
    }

    public static SkbShell newShell(MessageRenderer renderer, boolean useConsole) {
        return SkbShellFactory.newShell(null, renderer, useConsole);
    }

    public static SkbShell newShell(String id) {
        return SkbShellFactory.newShell(id, null, true);
    }

    public static SkbShell newShell(String id, boolean useConsole) {
        return SkbShellFactory.newShell(id, null, useConsole);
    }

    public static SkbShell newShell(String id, MessageRenderer renderer) {
        return SkbShellFactory.newShell(id, renderer, true);
    }

    public static SkbShell newShell(String id, MessageRenderer renderer, boolean useConsole) {
        return new AbstractShell(id, renderer, useConsole);
    }

    public static SkbShellCommand newCommand(String command, SkbShellArgument[] arguments, SkbShellCommandCategory category, String description, String addedHelp) {
        return new AbstractShellCommand(command, arguments, category, description, addedHelp);
    }

    public static SkbShellCommand newCommand(String command, SkbShellArgument argument, SkbShellCommandCategory category, String description, String addedHelp) {
        if (argument == null) {
            return new AbstractShellCommand(command, null, category, description, addedHelp);
        }
        return SkbShellFactory.newCommand(command, new SkbShellArgument[]{argument}, category, description, addedHelp);
    }

    public static SkbShellCommand newCommand(String command, SkbShellCommandCategory category, String description, String addedHelp) {
        return new AbstractShellCommand(command, null, category, description, addedHelp);
    }

    public static SkbShellArgument newArgument(String argument, boolean isOptional, SkbShellArgumentType type, Object[] valueSet, String description, String addedHelp) {
        return new AbstractShellArgument(argument, isOptional, type, valueSet, description, addedHelp);
    }

    public static SkbShellArgument[] newArgumentArray(SkbShellArgument ... args) {
        if (args == null) {
            return null;
        }
        HashSet<SkbShellArgument> ret = new HashSet<SkbShellArgument>();
        for (SkbShellArgument arg : args) {
            if (arg == null) continue;
            ret.add(arg);
        }
        return ret.toArray(new SkbShellArgument[args.length]);
    }

    public static SkbShellCommandCategory newCategory(String category, String description) {
        return new AbstractCategory(category, description);
    }
}

