/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.base.strings;

import de.vandermeer.skb.base.strings.VersionString;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class IdVersionString {
    protected String id;
    protected VersionString version;
    public static String NULL_STRING_RETURN = "NULL";
    public static IdVersionString NULL_STRING = new IdVersionString(){

        @Override
        public String toString() {
            return NULL_STRING_RETURN;
        }

        @Override
        public String getID() {
            return NULL_STRING_RETURN;
        }

        @Override
        public VersionString getVersion() {
            return null;
        }

        @Override
        public boolean sameAs(Object obj) {
            return obj instanceof IdVersionString && ((IdVersionString)obj).getID() == NULL_STRING_RETURN;
        }
    };

    public IdVersionString(String idv) {
        if (StringUtils.isBlank((CharSequence)idv)) {
            throw new IllegalArgumentException("idv string null or empty");
        }
        String[] ar = StringUtils.split((String)idv, (String)"/");
        if (ar == null || ar.length != 2) {
            throw new IllegalArgumentException("idv string of wrong format (split)");
        }
        if (StringUtils.isBlank((CharSequence)ar[0])) {
            throw new IllegalArgumentException("idv string with empty identifier part");
        }
        this.id = ar[0];
        this.version = new VersionString(ar[1]);
    }

    public IdVersionString(String id, String version) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("id part null or empty");
        }
        this.id = id;
        this.version = new VersionString(version);
    }

    private IdVersionString() {
    }

    public String toString() {
        return this.id + "/" + this.version;
    }

    public String getID() {
        return this.id;
    }

    public VersionString getVersion() {
        return this.version;
    }

    public Map<String, String> toMap() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("id", this.getID());
        ret.put("version", this.getVersion().toString());
        return ret;
    }

    public boolean sameAs(Object obj) {
        if (obj == null) {
            return false;
        }
        return (obj instanceof String || obj instanceof IdVersionString) && this.toString().equals(obj.toString());
    }
}

