/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.base.strings;

import de.vandermeer.skb.base.strings.IdVersionString;
import de.vandermeer.skb.base.strings.VersionString;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class IdVersionValueString {
    protected IdVersionString id;
    protected String value;

    public IdVersionValueString(String idv) {
        if (StringUtils.isBlank((CharSequence)idv)) {
            throw new IllegalArgumentException("idv string null or empty");
        }
        String[] ar = StringUtils.split((String)idv, (String)"/");
        if (ar == null || ar.length != 3) {
            throw new IllegalArgumentException("idv string of wrong format (split)");
        }
        this.id = new IdVersionString(ar[0], ar[1]);
        if (StringUtils.isBlank((CharSequence)ar[2])) {
            throw new IllegalArgumentException("idv string with empty value part");
        }
        this.value = ar[2];
    }

    public String getID() {
        return this.id.getID();
    }

    public Map<String, String> toMap() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("id", this.getID());
        ret.put("version", this.getVersion().toString());
        ret.put("value", this.getValue());
        return ret;
    }

    public VersionString getVersion() {
        return this.id.getVersion();
    }

    public String getValue() {
        return this.value;
    }
}

