/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.base.strings;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class VersionString {
    protected int major;
    protected int minor;
    protected int patch;
    protected char separator = (char)46;

    public VersionString(String version) {
        if (StringUtils.isBlank((CharSequence)version)) {
            throw new IllegalArgumentException("version string null or empty");
        }
        String[] ar = StringUtils.split((String)version, (String)"  - , .");
        if (ar == null || ar.length != 3) {
            throw new IllegalArgumentException("version string of wrong format (split)");
        }
        if (!(NumberUtils.isNumber((String)ar[0]) || NumberUtils.isNumber((String)ar[1]) || NumberUtils.isNumber((String)ar[2]))) {
            throw new IllegalArgumentException("some parts of the version string are not numbers");
        }
        this.major = NumberUtils.toInt((String)ar[0], (int)-1);
        this.minor = NumberUtils.toInt((String)ar[1], (int)-1);
        this.patch = NumberUtils.toInt((String)ar[2], (int)-1);
    }

    public VersionString(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public Integer getMajor() {
        return this.major;
    }

    public Integer getMinor() {
        return this.minor;
    }

    public Map<String, Integer> toMap() {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        ret.put("major", this.major);
        ret.put("minor", this.minor);
        ret.put("patch", this.patch);
        return ret;
    }

    public Integer getPatch() {
        return this.patch;
    }

    public void setSeparator(char c) {
        this.separator = c;
    }

    public String toString() {
        return String.format("%d%c%d%c%d", this.major, Character.valueOf(this.separator), this.minor, Character.valueOf(this.separator), this.patch);
    }
}

