/* Copyright 2017 Sven van der Meer <vdmeer.sven@mykolab.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.vandermeer.skb.interfaces.application;

/**
 * A parse exception for the CLI parser with error code as return value.
 * 
 * @author     Sven van der Meer &lt;vdmeer.sven@mykolab.com&gt;
 * @version    v0.0.2 build 170502 (02-May-17) for Java 1.8
 * @since      v0.0.2
 */
public class CliParseException extends ApplicationException {

	/** Serial version UID. */
	private static final long serialVersionUID = 717498044288446962L;

	/**
	 * Creates a new exception with message and error code.
	 * @param errorCode the error code as return value for an application
	 * @param message a message for the exception
	 */
	public CliParseException(final int errorCode, final String message){
		super(errorCode, message);
	}

}
