/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.interfaces.application;

import de.vandermeer.skb.interfaces.application.ApoBase;
import de.vandermeer.skb.interfaces.application.ApoBaseC;
import de.vandermeer.skb.interfaces.application.Apo_SimpleC;
import de.vandermeer.skb.interfaces.application.Apo_TypedC;
import de.vandermeer.skb.interfaces.application.CliOptionList;
import de.vandermeer.skb.interfaces.application.CliParseException;
import de.vandermeer.skb.interfaces.transformers.textformat.Text_To_FormattedText;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.text.StrBuilder;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroupFile;

public interface App_CliParser {
    public int numberShort();

    public int numberLong();

    default public App_CliParser addAllOptions(Object[] options) throws IllegalStateException {
        if (options != null) {
            for (Object opt : options) {
                this.addOption(opt);
            }
        }
        return this;
    }

    default public App_CliParser addAllOptions(Iterable<?> options) throws IllegalStateException {
        if (options != null) {
            for (Object opt : options) {
                this.addOption(opt);
            }
        }
        return this;
    }

    public App_CliParser addOption(Object var1) throws IllegalStateException;

    public Set<String> getAddedOptions();

    public Set<Apo_SimpleC> getSimpleOptions();

    public Set<Apo_TypedC<?>> getTypedOptions();

    public Set<ApoBaseC> getAllOptions();

    default public boolean hasOption(ApoBase option) {
        if (option == null) {
            return false;
        }
        if (option.getClass().isInstance(ApoBaseC.class)) {
            Apo_SimpleC simple = (Apo_SimpleC)option;
            if (this.getAddedOptions().contains(simple.getCliShort())) {
                return true;
            }
            if (this.getAddedOptions().contains(simple.getCliLong())) {
                return true;
            }
        }
        return false;
    }

    public void parse(String[] var1) throws CliParseException, IllegalStateException;

    default public ArrayList<StrBuilder> usage(int width) {
        TreeMap<String, ApoBaseC> map = CliOptionList.sortedMap(this.getAllOptions(), this.numberShort(), this.numberLong());
        LinkedHashMap<String, String> helpMap = new LinkedHashMap<String, String>();
        int length = 0;
        STGroupFile stg = new STGroupFile("de/vandermeer/skb/interfaces/application/help.stg");
        for (ApoBaseC option : map.values()) {
            String line;
            ST sto = stg.getInstanceOf("option");
            String description = null;
            if (ClassUtils.isAssignable(option.getClass(), Apo_SimpleC.class)) {
                sto.add("cliShort", (Object)((Apo_SimpleC)option).getCliShort());
                sto.add("cliLong", (Object)((Apo_SimpleC)option).getCliLong());
                description = ((Apo_SimpleC)option).getDescription();
            }
            if (ClassUtils.isAssignable(option.getClass(), Apo_TypedC.class)) {
                sto.add("cliShort", (Object)((Apo_TypedC)option).getCliShort());
                sto.add("cliLong", (Object)((Apo_TypedC)option).getCliLong());
                sto.add("argName", (Object)((Apo_TypedC)option).getCliArgumentName());
                sto.add("argOptional", (Object)((Apo_TypedC)option).cliArgIsOptional());
                description = ((Apo_TypedC)option).getDescription();
            }
            if ((line = sto.render()).length() > length) {
                length = line.length();
            }
            helpMap.put(line, description);
        }
        length += 4;
        ArrayList<StrBuilder> ret = new ArrayList<StrBuilder>();
        for (Map.Entry entry : helpMap.entrySet()) {
            StrBuilder argLine = new StrBuilder();
            argLine.append((String)entry.getKey()).appendPadding(length - argLine.length(), ' ');
            StrBuilder padLine = new StrBuilder();
            padLine.appendPadding(length, ' ');
            Collection<StrBuilder> text = Text_To_FormattedText.left((String)entry.getValue(), width - length);
            int i = 0;
            for (StrBuilder b : text) {
                if (i == 0) {
                    b.insert(0, (Object)argLine);
                } else {
                    b.insert(0, (Object)padLine);
                }
                ret.add(b);
                ++i;
            }
        }
        return ret;
    }

    default public ArrayList<StrBuilder> usage() {
        return this.usage(80);
    }
}

