/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.interfaces.application;

import de.vandermeer.skb.interfaces.application.ApoBaseC;
import de.vandermeer.skb.interfaces.application.Apo_TypedC;
import java.util.Collection;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.ClassUtils;

public interface CliOptionList {
    public static Set<String> getRequired(Set<ApoBaseC> list) {
        TreeSet<String> ret = new TreeSet<String>();
        if (list != null) {
            for (ApoBaseC opt : list) {
                String required;
                if (!opt.cliIsRequired()) continue;
                String string = required = opt.getCliShortLong() == null ? "--" + opt.getCliLong() : "-" + opt.getCliShort();
                if (ClassUtils.isAssignable(opt.getClass(), Apo_TypedC.class)) {
                    required = required + " <" + ((Apo_TypedC)opt).getCliArgumentName() + ">";
                }
                ret.add(required);
            }
        }
        return ret;
    }

    public static TreeMap<String, ApoBaseC> sortedMap(Set<ApoBaseC> list, int numberShort, int numberLong) {
        TreeMap<String, ApoBaseC> ret = new TreeMap<String, ApoBaseC>();
        if (list == null) {
            return ret;
        }
        for (ApoBaseC opt : list) {
            if (numberShort == 0) {
                String string = opt.getCliLong();
            }
            String key = numberLong == 0 ? opt.getCliShort().toString() : (opt.getCliLong() != null ? (opt.getCliShort() != null ? opt.getCliShort().toString() + "," + opt.getCliLong() : opt.getCliLong().charAt(0) + "," + opt.getCliLong()) : opt.getCliShort().toString());
            ret.put(key.toLowerCase(), opt);
        }
        return ret;
    }

    public static Collection<ApoBaseC> sortedList(Set<ApoBaseC> list, int numberShort, int numberLong) {
        return CliOptionList.sortedMap(list, numberShort, numberLong).values();
    }
}

