/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.interfaces.application;

import de.vandermeer.skb.interfaces.application.ApoBase;
import de.vandermeer.skb.interfaces.application.ApoBaseC;
import de.vandermeer.skb.interfaces.application.ApoBaseTyped;
import de.vandermeer.skb.interfaces.application.Apo_SimpleC;
import de.vandermeer.skb.interfaces.application.Apo_TypedC;
import de.vandermeer.skb.interfaces.application.Apo_TypedE;
import de.vandermeer.skb.interfaces.application.Apo_TypedP;
import de.vandermeer.skb.interfaces.application.App_CliParser;
import de.vandermeer.skb.interfaces.application.CliOptionList;
import de.vandermeer.skb.interfaces.application.CliParseException;
import de.vandermeer.skb.interfaces.application.EnvironmentOptionsList;
import de.vandermeer.skb.interfaces.application.PropertyOptionsList;
import de.vandermeer.skb.interfaces.categories.CategoryIs;
import de.vandermeer.skb.interfaces.categories.has.HasDescription;
import de.vandermeer.skb.interfaces.transformers.textformat.Text_To_FormattedText;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.StrBuilder;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroupFile;

public interface IsApplication
extends CategoryIs,
HasDescription {
    public static boolean IN_ARRAY(String[] array, ApoBaseC apo) {
        if (array == null || array.length == 0 || apo == null) {
            return false;
        }
        if (ArrayUtils.contains((Object[])array, (Object)("-" + apo.getCliShort()))) {
            return true;
        }
        return ArrayUtils.contains((Object[])array, (Object)("--" + apo.getCliLong()));
    }

    default public void addAllOptions(Iterable<?> options) {
        if (options != null) {
            for (Object opt : options) {
                this.addOption(opt);
            }
        }
    }

    default public void addAllOptions(Object[] options) {
        if (options != null) {
            for (Object opt : options) {
                this.addOption(opt);
            }
        }
    }

    default public void addOption(Object option) {
        if (option == null) {
            return;
        }
        if (ClassUtils.isAssignable(option.getClass(), Apo_SimpleC.class)) {
            this.getCliParser().addOption((Apo_SimpleC)option);
        }
        if (ClassUtils.isAssignable(option.getClass(), Apo_TypedC.class)) {
            this.getCliParser().addOption((Apo_TypedC)option);
        }
        if (ClassUtils.isAssignable(option.getClass(), Apo_TypedE.class)) {
            Apo_TypedE eo = (Apo_TypedE)option;
            for (Apo_TypedE<?> apo_TypedE : this.getEnvironmentOptions()) {
                Validate.validState((!apo_TypedE.getEnvironmentKey().equals(eo.getEnvironmentKey()) ? 1 : 0) != 0, (String)(this.getAppName() + ": environment option <" + eo.getEnvironmentKey() + "> already in use"), (Object[])new Object[0]);
            }
            this.getEnvironmentOptions().add(eo);
        }
        if (ClassUtils.isAssignable(option.getClass(), Apo_TypedP.class)) {
            Apo_TypedP po = (Apo_TypedP)option;
            for (Apo_TypedP apo_TypedP : this.getPropertyOptions()) {
                Validate.validState((!apo_TypedP.getPropertyKey().equals(po.getPropertyKey()) ? 1 : 0) != 0, (String)(this.getAppName() + ": property option <" + po.getPropertyKey() + "> already in use"), (Object[])new Object[0]);
            }
            this.getPropertyOptions().add(po);
        }
    }

    default public void appHelpScreen() {
        int i;
        Collection<StrBuilder> text;
        StrBuilder padLine;
        StrBuilder argLine;
        int length;
        LinkedHashMap<String, String> envMap;
        TreeMap<String, ApoBaseTyped<?>> map;
        STGroupFile stg = new STGroupFile("de/vandermeer/skb/interfaces/application/help.stg");
        ST st = stg.getInstanceOf("usage");
        st.add("appName", (Object)this.getAppName());
        st.add("appDisplayName", (Object)this.getAppDisplayName());
        st.add("appVersion", (Object)this.getAppVersion());
        st.add("appDescription", Text_To_FormattedText.left(this.getAppDescription(), this.getConsoleWidth()));
        st.add("required", CliOptionList.getRequired(this.getCLiALlOptions()));
        for (StrBuilder sb : this.getCliParser().usage(this.getConsoleWidth())) {
            st.add("cliOptions", (Object)sb);
        }
        if (this.getEnvironmentOptions().size() > 0) {
            map = EnvironmentOptionsList.sortedMap(this.getEnvironmentOptions());
            envMap = new LinkedHashMap<String, String>();
            length = 0;
            for (Apo_TypedE apo_TypedE : map.values()) {
                if (apo_TypedE.getEnvironmentKey().length() > length) {
                    length = apo_TypedE.getEnvironmentKey().length();
                }
                envMap.put(apo_TypedE.getEnvironmentKey(), apo_TypedE.getDescription());
            }
            length += 2;
            for (Map.Entry entry : envMap.entrySet()) {
                argLine = new StrBuilder();
                argLine.append((String)entry.getKey()).appendPadding(length - argLine.length(), ' ').append("  - ");
                padLine = new StrBuilder();
                padLine.appendPadding(length + 4, ' ');
                text = Text_To_FormattedText.left((String)entry.getValue(), this.getConsoleWidth() - length);
                i = 0;
                for (StrBuilder b : text) {
                    if (i == 0) {
                        st.add("envOptions", (Object)(argLine + b.build()));
                    } else {
                        st.add("envOptions", (Object)(padLine + b.build()));
                    }
                    ++i;
                }
            }
        }
        if (this.getPropertyOptions().size() > 0) {
            map = PropertyOptionsList.sortedMap(this.getPropertyOptions());
            envMap = new LinkedHashMap();
            length = 0;
            for (Apo_TypedP apo_TypedP : map.values()) {
                if (apo_TypedP.getPropertyKey().length() > length) {
                    length = apo_TypedP.getPropertyKey().length();
                }
                envMap.put(apo_TypedP.getPropertyKey(), apo_TypedP.getDescription());
            }
            length += 2;
            for (Map.Entry entry : envMap.entrySet()) {
                argLine = new StrBuilder();
                argLine.append((String)entry.getKey()).appendPadding(length - argLine.length(), ' ').append("  - ");
                padLine = new StrBuilder();
                padLine.appendPadding(length + 4, ' ');
                text = Text_To_FormattedText.left((String)entry.getValue(), this.getConsoleWidth() - length);
                i = 0;
                for (StrBuilder b : text) {
                    if (i == 0) {
                        st.add("propOptions", (Object)(argLine + b.build()));
                    } else {
                        st.add("propOptions", (Object)(padLine + b.build()));
                    }
                    ++i;
                }
            }
        }
        System.out.println(st.render());
    }

    default public void appHelpScreen(String arg) {
        if (StringUtils.isBlank((CharSequence)arg)) {
            return;
        }
        ApoBase opt = null;
        for (ApoBaseC apoBaseC : this.getCLiALlOptions()) {
            if (apoBaseC.getCliShort() != null && arg.equals(apoBaseC.getCliShort().toString())) {
                opt = apoBaseC;
                break;
            }
            if (!arg.equals(apoBaseC.getCliLong())) continue;
            opt = apoBaseC;
            break;
        }
        if (opt == null) {
            for (Apo_TypedP apo_TypedP : this.getPropertyOptions()) {
                if (!arg.equals(apo_TypedP.getPropertyKey())) continue;
                opt = apo_TypedP;
                break;
            }
        }
        if (opt == null) {
            for (Apo_TypedE apo_TypedE : this.getEnvironmentOptions()) {
                if (!arg.equals(apo_TypedE.getEnvironmentKey())) continue;
                opt = apo_TypedE;
                break;
            }
        }
        if (opt == null) {
            System.err.println(this.getAppName() + ": unknown option -> " + arg);
        } else {
            ST st = opt.getHelp();
            st.add("longDescr", (Object)this.longDescriptionString(opt.getLongDescription()));
            st.add("strongLine", (Object)new StrBuilder().appendPadding(this.getConsoleWidth(), '='));
            st.add("line", (Object)new StrBuilder().appendPadding(this.getConsoleWidth(), '-'));
            System.out.println(st.render());
        }
    }

    default public Apo_SimpleC cliSimpleHelpOption() {
        return null;
    }

    default public Apo_TypedC<String> cliTypedHelpOption() {
        return null;
    }

    default public Apo_SimpleC cliVersionOption() {
        return null;
    }

    default public int executeApplication(String[] args) {
        if (this.cliSimpleHelpOption() != null && !this.getCliParser().hasOption(this.cliSimpleHelpOption())) {
            this.getCliParser().addOption(this.cliSimpleHelpOption());
        } else if (this.cliTypedHelpOption() != null && !this.getCliParser().hasOption(this.cliTypedHelpOption())) {
            this.getCliParser().addOption(this.cliTypedHelpOption());
        }
        if (this.cliVersionOption() != null && !this.getCliParser().hasOption(this.cliVersionOption())) {
            this.getCliParser().addOption(this.cliVersionOption());
        }
        if (IsApplication.IN_ARRAY(args, this.cliVersionOption())) {
            System.out.println(this.getAppVersion());
            return 1;
        }
        if (IsApplication.IN_ARRAY(args, this.cliSimpleHelpOption())) {
            this.appHelpScreen();
            return 1;
        }
        if (IsApplication.IN_ARRAY(args, this.cliTypedHelpOption())) {
            if (args.length == 1) {
                this.appHelpScreen();
                return 1;
            }
            if (args.length == 2) {
                this.appHelpScreen(args[1]);
                return 1;
            }
            System.err.println(this.getAppName() + ": help requested but too many arguments given");
            return -1;
        }
        try {
            this.getCliParser().parse(args);
        }
        catch (IllegalStateException ex) {
            System.err.println(this.getAppName() + ": error parsing command line -> " + ex.getMessage());
            System.err.println(this.getAppName() + ": try '--help' for list of CLI options or '--help <option>' for detailed help on a CLI option");
            return -1;
        }
        catch (CliParseException e) {
            System.err.println(this.getAppName() + ": error: " + e.getMessage());
            System.err.println(this.getAppName() + ": try '--help' for list of CLI options or '--help <option>' for detailed help on a CLI option");
            return e.getErrorCode();
        }
        return 0;
    }

    public String getAppDescription();

    default public String getAppDisplayName() {
        return this.getAppName();
    }

    public String getAppName();

    public String getAppVersion();

    default public Set<ApoBaseC> getCLiALlOptions() {
        return this.getCliParser().getAllOptions();
    }

    public App_CliParser getCliParser();

    default public Set<Apo_SimpleC> getCliSimpleOptions() {
        return this.getCliParser().getSimpleOptions();
    }

    default public Set<Apo_TypedC<?>> getCliTypedOptions() {
        return this.getCliParser().getTypedOptions();
    }

    default public int getConsoleWidth() {
        return 80;
    }

    @Override
    default public String getDescription() {
        return this.getAppDescription();
    }

    public Set<Apo_TypedE<?>> getEnvironmentOptions();

    public Set<Apo_TypedP<?>> getPropertyOptions();

    public String longDescriptionString(Object var1);
}

