/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.base.utils;

import de.vandermeer.skb.base.Skb_BaseException;
import java.util.function.Predicate;

public abstract class Skb_ClassUtils {
    public static final Predicate<Object> IS_SUBCLASS_OF(final Object superClass) {
        return new Predicate<Object>(){

            @Override
            public boolean test(Object subClass) {
                if (superClass == null || subClass == null) {
                    return false;
                }
                if (superClass instanceof Class && subClass instanceof Class) {
                    return ((Class)superClass).isAssignableFrom((Class)subClass);
                }
                if (superClass instanceof Class && !(subClass instanceof Class)) {
                    return ((Class)superClass).isAssignableFrom(subClass.getClass());
                }
                if (!(superClass instanceof Class) && subClass instanceof Class) {
                    return superClass.getClass().isAssignableFrom((Class)subClass);
                }
                return superClass.getClass().isAssignableFrom(subClass.getClass());
            }
        };
    }

    public static final Predicate<Object> IS_SUPERCLASS_OF(final Object subClass) {
        return new Predicate<Object>(){

            @Override
            public boolean test(Object superClass) {
                if (superClass == null || subClass == null) {
                    return false;
                }
                if (superClass instanceof Class && subClass instanceof Class) {
                    return ((Class)superClass).isAssignableFrom((Class)subClass);
                }
                if (superClass instanceof Class && !(subClass instanceof Class)) {
                    return ((Class)superClass).isAssignableFrom(subClass.getClass());
                }
                if (!(superClass instanceof Class) && subClass instanceof Class) {
                    return superClass.getClass().isAssignableFrom((Class)subClass);
                }
                return superClass.getClass().isAssignableFrom(subClass.getClass());
            }
        };
    }

    public static final Predicate<Object> INSTANCE_OF(final Object lhs) throws Skb_BaseException {
        return new Predicate<Object>(){

            @Override
            public boolean test(Object rhs) {
                if (lhs == null || rhs == null) {
                    return false;
                }
                if (lhs instanceof Class && rhs instanceof Class) {
                    throw new Skb_BaseException("wrong arguments", "cannot check instance of class with class");
                }
                if (lhs instanceof Class && !(rhs instanceof Class)) {
                    return ((Class)lhs).isInstance(rhs);
                }
                if (!(lhs instanceof Class) && rhs instanceof Class) {
                    throw new Skb_BaseException("wrong arguments", "cannot check instance of object with class");
                }
                return lhs.getClass().isInstance(rhs);
            }
        };
    }
}

