/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.base.utils;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupDir;
import org.stringtemplate.v4.STGroupFile;
import org.stringtemplate.v4.STGroupString;

public abstract class Skb_STUtils {
    public static final Map<String, List<String>> getMissingChunks(STGroup stg, Map<String, List<String>> expectedChunks) {
        if (stg == null || expectedChunks == null) {
            return null;
        }
        LinkedHashMap<String, List<String>> ret = new LinkedHashMap<String, List<String>>();
        for (String s : expectedChunks.keySet()) {
            if (s == null || "".equals(s)) continue;
            if (stg.isDefined(s)) {
                List<String> missingArgs = Skb_STUtils.getMissingSTArguments(stg.getInstanceOf(s), expectedChunks.get(s));
                if (missingArgs == null || missingArgs.size() <= 0) continue;
                ret.put(s, missingArgs);
                continue;
            }
            ret.put(s, null);
        }
        return ret;
    }

    public static final List<String> getMissingSTArguments(ST st, List<String> expectedArguments) {
        ArrayList<String> ret;
        if (st == null) {
            return null;
        }
        if (expectedArguments == null) {
            return null;
        }
        Map formalArgs = st.impl.formalArguments;
        if (formalArgs == null) {
            ret = new ArrayList<String>(expectedArguments);
        } else {
            ret = new ArrayList();
            for (int i = 0; i < expectedArguments.size(); ++i) {
                if (formalArgs.containsKey(expectedArguments.get(i))) continue;
                ret.add(expectedArguments.get(i));
            }
        }
        return ret;
    }

    public static final Set<String> getMissingChunksErrorMessages(String name, Map<String, List<String>> missingChunks) {
        LinkedHashSet<String> ret = new LinkedHashSet<String>();
        String msgST = "template group<if(%1)> \\<<%1>><endif> does not specify mandatory string template \\<<%2>>";
        String msgArg = "template group<if(%1)> \\<<%1>><endif> with string template \\<<%2>> does not define argument \\<<%3>>";
        Set<String> keys = missingChunks.keySet();
        for (String missing : keys) {
            List<String> missingArgs = missingChunks.get(missing);
            if (missingArgs == null || missingArgs.size() == 0) {
                ret.add(ST.format((String)msgST, (Object[])new Object[]{name, missing}));
                continue;
            }
            for (String arg : missingArgs) {
                ret.add(ST.format((String)msgArg, (Object[])new Object[]{name, missing, arg}));
            }
        }
        return ret;
    }

    public static final String getStgName(STGroup stg) {
        String ret = null;
        if (stg instanceof STGroupFile) {
            ret = ((STGroupFile)stg).fileName;
        } else if (stg instanceof STGroupString) {
            ret = ((STGroupString)stg).sourceName;
        } else if (stg instanceof STGroupDir) {
            ret = ((STGroupDir)stg).groupDirName;
        }
        return StringUtils.substringBeforeLast((String)ret, (String)".");
    }
}

