/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.base.utils;

import de.vandermeer.skb.base.Skb_Transformer;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang3.text.StrBuilder;

public abstract class Skb_TextUtils {
    public static final <T> Skb_Transformer<T[][], StrBuilder> ARRAY_TO_TEXT() {
        return new Skb_Transformer<T[][], StrBuilder>(){

            @Override
            public StrBuilder transform(T[][] ar) {
                StrBuilder ret = new StrBuilder(50);
                for (int row = 0; row < ar.length; ++row) {
                    if (ar[row] == null) {
                        ret.append("[").append(row).appendln("]: null");
                        continue;
                    }
                    if (ar[row].length == 0) {
                        ret.append("[").append(row).appendln("]: 0");
                        continue;
                    }
                    for (int col = 0; col < ar[row].length; ++col) {
                        ret.append("[").append(row).append("][").append(col).append("]: ");
                        if (ar[row][col] == null) {
                            ret.appendln("null");
                            continue;
                        }
                        if ("".equals(ar[row][col])) {
                            ret.appendln("0");
                            continue;
                        }
                        ret.appendln(ar[row][col]);
                    }
                }
                return ret;
            }
        };
    }

    public static final Skb_Transformer<Map<String, ?>, String> MAP_TO_TEXT() {
        return new Skb_Transformer<Map<String, ?>, String>(){

            @Override
            public String transform(Map<String, ?> map) {
                StrBuilder ret = new StrBuilder(map.size() * 20);
                TreeSet<String> keys = new TreeSet<String>(map.keySet());
                for (String leaf : keys) {
                    ret.append("--> ").append(leaf);
                    ret.append(" ::= ");
                    ret.append(map.get(leaf));
                    ret.append('\n');
                }
                return ret.toString();
            }
        };
    }

    public static final <T> Skb_Transformer<Object, StrBuilder> MANYOBJECTS_TO_STRBUILDER(final Object separator, final Skb_Transformer<Object, T> toText) {
        return new Skb_Transformer<Object, StrBuilder>(){

            @Override
            public StrBuilder transform(Object obj) {
                StrBuilder ret = new StrBuilder(50);
                if (obj != null && toText != null) {
                    if (obj instanceof Iterator) {
                        while (((Iterator)obj).hasNext()) {
                            ret.appendSeparator(separator.toString());
                            ret.append(toText.transform(((Iterator)obj).next()));
                        }
                    } else if (obj instanceof Iterable) {
                        for (Object o : (Iterable)obj) {
                            ret.appendSeparator(separator.toString());
                            ret.append(toText.transform(o));
                        }
                    } else if (obj instanceof Object[]) {
                        for (int i = 0; i < ((Object[])obj).length; ++i) {
                            ret.appendSeparator(separator.toString());
                            ret.append(toText.transform(((Object[])obj)[i]));
                        }
                    } else {
                        ret.appendSeparator(separator.toString());
                        ret.append(toText.transform(obj));
                    }
                }
                return ret;
            }
        };
    }

    public static final Skb_Transformer<Object, String> TO_STRING() {
        return new Skb_Transformer<Object, String>(){

            @Override
            public String transform(Object obj) {
                if (obj instanceof String) {
                    return (String)obj;
                }
                if (obj != null) {
                    return obj.toString();
                }
                return "";
            }
        };
    }
}

