/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.svg2vector.applications.base;

import de.vandermeer.execs.ExecS_Application;
import de.vandermeer.execs.options.ApplicationOption;
import de.vandermeer.execs.options.ExecS_CliParser;
import de.vandermeer.svg2vector.applications.base.AppProperties;
import de.vandermeer.svg2vector.applications.base.SV_DocumentLoader;
import de.vandermeer.svg2vector.applications.base.SvgTargets;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.StrBuilder;

public abstract class AppBase<L extends SV_DocumentLoader, P extends AppProperties<L>>
implements ExecS_Application {
    private final ExecS_CliParser cli;
    private final P props;

    protected AppBase(P props) {
        Validate.notNull(props);
        this.props = props;
        this.cli = new ExecS_CliParser();
        this.cli.addAllOptions(((AppProperties)this.props).getAppOptions());
    }

    protected void addOption(ApplicationOption<?> option) {
        if (option != null) {
            this.getCli().addOption(option);
            ((AppProperties)this.props).addOption(option);
        }
    }

    public int executeApplication(String[] args) {
        int ret = super.executeApplication(args);
        if (ret != 0) {
            return ret;
        }
        ((AppProperties)this.props).setMessageMode();
        SvgTargets target = ((AppProperties)this.props).getTarget();
        if (target == null) {
            this.printErrorMessage("given target <" + ((AppProperties)this.props).getTargetValue() + "> not supported. Use one of the supported targets: " + new StrBuilder().appendWithSeparators((Object[])((AppProperties)this.props).getSupportedTargetts(), ", "));
            return -10;
        }
        String err = null;
        err = ((AppProperties)this.props).setInput();
        if (err != null) {
            this.printErrorMessage(err);
            return -11;
        }
        this.printWarnings();
        err = ((AppProperties)this.props).setOutput();
        if (err != null) {
            this.printErrorMessage(err);
            return -12;
        }
        this.printWarnings();
        if (((AppProperties)this.props).doesNoLayers()) {
            this.printProgressMessage("processing single output, no layers");
            this.printDetailMessage("target:           " + target.name());
            this.printDetailMessage("input fn:         " + ((AppProperties)this.props).getFinFn());
            this.printDetailMessage("output fn:        " + ((AppProperties)this.props).getFoutFn());
        } else if (((AppProperties)this.props).doesLayers()) {
            this.printProgressMessage("processing multi layer, multi file output");
            this.printDetailMessage("target:           " + target.name());
            this.printDetailMessage("input fn:         " + ((AppProperties)this.props).getFinFn());
            this.printDetailMessage("output dir:       " + ((AppProperties)this.props).getDout());
            this.printDetailMessage("fn pattern:       " + ((AppProperties)this.props).getFoutPattern());
        } else {
            this.printErrorMessage("implementation error: something wrong with property settings");
            return -13;
        }
        if (((AppProperties)this.props).doesCreateDirectories()) {
            this.printProgressMessage("creating directories for output");
            if (((AppProperties)this.props).getFoutFile() != null) {
                if (((AppProperties)this.props).canWriteFiles()) {
                    ((AppProperties)this.props).getFoutFile().getParentFile().mkdirs();
                }
                this.printDetailMessage("create directories (fout): " + ((AppProperties)this.props).getFoutFile().getParent());
            }
            if (((AppProperties)this.props).getDoutFile() != null) {
                if (((AppProperties)this.props).canWriteFiles()) {
                    ((AppProperties)this.props).getDoutFile().mkdirs();
                }
                this.printDetailMessage("create directories (dout): " + ((AppProperties)this.props).getDout());
            }
        }
        return 0;
    }

    public ApplicationOption<?>[] getAppOptions() {
        return ((AppProperties)this.props).getAppOptions();
    }

    public ExecS_CliParser getCli() {
        return this.cli;
    }

    public P getProps() {
        return this.props;
    }

    private boolean isSet(int mask) {
        return (((AppProperties)this.props).getMsgMode() & mask) == mask;
    }

    public void printDetailMessage(String msg) {
        this.printMessage(msg, AppProperties.P_OPTION_DEAILS);
    }

    public void printErrorMessage(String err) {
        this.printMessage(err, AppProperties.P_OPTION_ERROR);
    }

    private void printMessage(String msg, int type) {
        if (msg == null) {
            return;
        }
        if (this.isSet(type)) {
            if (type == AppProperties.P_OPTION_ERROR) {
                System.err.println(this.getAppName() + " error: " + msg);
            } else if (type == AppProperties.P_OPTION_WARNING) {
                System.out.println(this.getAppName() + " warning: " + msg);
            } else if (type == AppProperties.P_OPTION_PROGRESS) {
                System.out.println(this.getAppName() + ": --- " + msg);
            } else if (type == AppProperties.P_OPTION_DEAILS) {
                System.out.println(this.getAppName() + ": === " + msg);
            } else {
                throw new IllegalArgumentException("messaging: unknown type: " + type);
            }
        }
    }

    public void printProgressMessage(String msg) {
        this.printMessage(msg, AppProperties.P_OPTION_PROGRESS);
    }

    public void printWarningMessage(String msg) {
        this.printMessage(msg, AppProperties.P_OPTION_WARNING);
    }

    public void printWarnings() {
        if (((AppProperties)this.props).warnings.size() > 0) {
            for (String msg : ((AppProperties)this.props).warnings) {
                this.printWarningMessage(msg);
            }
            ((AppProperties)this.props).warnings.clear();
        }
    }
}

