/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.svg2vector.applications.base;

import de.vandermeer.execs.options.AO_DirectoryOut;
import de.vandermeer.execs.options.AO_FileIn;
import de.vandermeer.execs.options.AO_FileOut;
import de.vandermeer.execs.options.AO_Quiet;
import de.vandermeer.execs.options.AO_Verbose;
import de.vandermeer.execs.options.ApplicationOption;
import de.vandermeer.svg2vector.applications.base.AO_CreateDirectories;
import de.vandermeer.svg2vector.applications.base.AO_FoutLayerId;
import de.vandermeer.svg2vector.applications.base.AO_FoutLayerIndex;
import de.vandermeer.svg2vector.applications.base.AO_FoutNoBasename;
import de.vandermeer.svg2vector.applications.base.AO_KeepTmpArtifacts;
import de.vandermeer.svg2vector.applications.base.AO_Layers;
import de.vandermeer.svg2vector.applications.base.AO_LayersIfExist;
import de.vandermeer.svg2vector.applications.base.AO_MsgDetail;
import de.vandermeer.svg2vector.applications.base.AO_MsgProgress;
import de.vandermeer.svg2vector.applications.base.AO_MsgWarning;
import de.vandermeer.svg2vector.applications.base.AO_NoErrors;
import de.vandermeer.svg2vector.applications.base.AO_OverwriteExisting;
import de.vandermeer.svg2vector.applications.base.AO_Simulate;
import de.vandermeer.svg2vector.applications.base.AO_SwitchOnLayers;
import de.vandermeer.svg2vector.applications.base.AO_TargetExt;
import de.vandermeer.svg2vector.applications.base.AO_TextAsShape;
import de.vandermeer.svg2vector.applications.base.AO_UseBaseName;
import de.vandermeer.svg2vector.applications.base.SV_DocumentLoader;
import de.vandermeer.svg2vector.applications.base.SvgTargets;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.StrBuilder;
import org.apache.commons.lang3.text.StrSubstitutor;

public class AppProperties<L extends SV_DocumentLoader> {
    public static int P_OPTION_QUIET = 0;
    public static int P_OPTION_ERROR = 1;
    public static int P_OPTION_WARNING = 2;
    public static int P_OPTION_PROGRESS = 4;
    public static int P_OPTION_DEAILS = 8;
    public static int P_OPTION_VERBOSE = P_OPTION_ERROR | P_OPTION_WARNING | P_OPTION_PROGRESS | P_OPTION_DEAILS;
    public static String SUBST_PATTERN_INDEX = "${index}";
    public static String SUBST_PATTERN_ID = "${id}";
    private final ArrayList<ApplicationOption<?>> options = new ArrayList();
    private final ArrayList<ApplicationOption<?>> noLayersWarnings;
    private final ArrayList<ApplicationOption<?>> withLayersWarnings;
    private final AO_Verbose aoVerbose = new AO_Verbose(Character.valueOf('v'));
    private final AO_Quiet aoQuiet = new AO_Quiet("appliction will be absolutely quiet, no output to sterr or stout.");
    private final AO_MsgProgress aoMsgProgress = new AO_MsgProgress();
    private final AO_MsgWarning aoMsgWarning = new AO_MsgWarning();
    private final AO_MsgDetail aoMsgDetail = new AO_MsgDetail();
    private final AO_NoErrors aoNoErrors = new AO_NoErrors();
    private final AO_TargetExt aoTarget;
    private final AO_FileIn aoFileIn = new AO_FileIn(true, Character.valueOf('f'), "input file <file>, must be a valid SVG file, can be compressed SVG (svgz)");
    private final AO_FileOut aoFileOut = new AO_FileOut(false, Character.valueOf('o'), "output file name, default is the basename of the input file plus target extension");
    private final AO_DirectoryOut aoDirOut = new AO_DirectoryOut(false, Character.valueOf('d'), "output directory, default value is the current directory");
    private final AO_CreateDirectories aoCreateDirs = new AO_CreateDirectories();
    private final AO_OverwriteExisting aoOverwriteExisting = new AO_OverwriteExisting();
    private final AO_KeepTmpArtifacts aoKeepTmpArtifacts = new AO_KeepTmpArtifacts();
    private final AO_Simulate aoSimulate = new AO_Simulate();
    private final AO_SwitchOnLayers aoSwitchOnLayers = new AO_SwitchOnLayers();
    private final AO_Layers aoLayers = new AO_Layers();
    private final AO_LayersIfExist aoLayersIfExists = new AO_LayersIfExist();
    private final AO_FoutLayerIndex aoFoutLayerIndex = new AO_FoutLayerIndex();
    private final AO_FoutLayerId aoFoutLayerId = new AO_FoutLayerId();
    private final AO_FoutNoBasename aoFoutNoBasename = new AO_FoutNoBasename();
    private final AO_UseBaseName aoUseBaseName = new AO_UseBaseName();
    private final AO_TextAsShape aoTextAsShape = new AO_TextAsShape();
    private String fin;
    private File fout;
    private String dout;
    private File doutFile;
    private String foutPattern;
    private L loader;
    protected ArrayList<String> warnings = new ArrayList();
    private int msgMode = P_OPTION_ERROR;

    public AppProperties(SvgTargets[] targets, L loader) {
        Validate.noNullElements((Object[])targets);
        Validate.notNull(loader);
        this.loader = loader;
        this.aoDirOut.setDefaultValue((Object)System.getProperty("user.dir"));
        this.aoTarget = new AO_TargetExt(true, Character.valueOf('t'), "target for the conversion", targets);
        this.addOption((ApplicationOption<?>)this.aoVerbose);
        this.addOption((ApplicationOption<?>)this.aoQuiet);
        this.addOption((ApplicationOption<?>)this.aoMsgProgress);
        this.addOption((ApplicationOption<?>)this.aoMsgDetail);
        this.addOption((ApplicationOption<?>)this.aoMsgWarning);
        this.addOption((ApplicationOption<?>)this.aoNoErrors);
        this.addOption((ApplicationOption<?>)this.aoTarget);
        this.addOption((ApplicationOption<?>)this.aoSimulate);
        this.addOption((ApplicationOption<?>)this.aoKeepTmpArtifacts);
        this.addOption((ApplicationOption<?>)this.aoFileIn);
        this.addOption((ApplicationOption<?>)this.aoFileOut);
        this.addOption((ApplicationOption<?>)this.aoDirOut);
        this.addOption((ApplicationOption<?>)this.aoCreateDirs);
        this.addOption((ApplicationOption<?>)this.aoOverwriteExisting);
        this.addOption((ApplicationOption<?>)this.aoSwitchOnLayers);
        this.addOption((ApplicationOption<?>)this.aoLayers);
        this.addOption((ApplicationOption<?>)this.aoLayersIfExists);
        this.addOption((ApplicationOption<?>)this.aoFoutLayerIndex);
        this.addOption((ApplicationOption<?>)this.aoFoutLayerId);
        this.addOption((ApplicationOption<?>)this.aoFoutNoBasename);
        this.addOption((ApplicationOption<?>)this.aoUseBaseName);
        this.addOption((ApplicationOption<?>)this.aoTextAsShape);
        this.noLayersWarnings = new ArrayList();
        this.noLayersWarnings.add((ApplicationOption<?>)this.aoFoutLayerIndex);
        this.noLayersWarnings.add((ApplicationOption<?>)this.aoFoutLayerId);
        this.noLayersWarnings.add((ApplicationOption<?>)this.aoFoutNoBasename);
        this.noLayersWarnings.add((ApplicationOption<?>)this.aoUseBaseName);
        this.withLayersWarnings = new ArrayList();
        this.withLayersWarnings.add((ApplicationOption<?>)this.aoSwitchOnLayers);
        this.withLayersWarnings.add((ApplicationOption<?>)this.aoFileOut);
    }

    public void addOption(ApplicationOption<?> option) {
        if (option != null) {
            this.options.add(option);
        }
    }

    public boolean doesLayers() {
        return this.getFoutFn() == null && this.getDout() != null && this.getFoutPattern() != null;
    }

    public boolean doesNoLayers() {
        return this.getFoutFn() != null && this.getDout() == null && this.getFoutPattern() == null;
    }

    public boolean doesSimulate() {
        return this.aoSimulate.inCli();
    }

    public boolean canWriteFiles() {
        return !this.aoSimulate.inCli();
    }

    public boolean doesCreateDirectories() {
        return this.aoCreateDirs.inCli();
    }

    public boolean doesTextAsShape() {
        return this.aoTextAsShape.inCli();
    }

    public ApplicationOption<?>[] getAppOptions() {
        return this.options.toArray(new ApplicationOption[0]);
    }

    public String getDout() {
        return this.dout;
    }

    public File getDoutFile() {
        return this.doutFile;
    }

    public String getFinFn() {
        return this.fin;
    }

    public String getFnOut(Map.Entry<String, Integer> entry) {
        if (!this.doesLayers() || entry == null || entry.getKey() == null || entry.getValue() == null) {
            return null;
        }
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        valuesMap.put("id", entry.getKey());
        valuesMap.put("index", String.format("%02d", entry.getValue()));
        return new StrSubstitutor(valuesMap).replace(this.foutPattern);
    }

    public String getFnOutNoDir(Map.Entry<String, Integer> entry) {
        String fn = this.getFnOut(entry);
        if (fn == null) {
            return null;
        }
        return StringUtils.substringAfterLast((String)fn, (String)"/");
    }

    public String getFoutFn() {
        return (String)this.aoFileOut.getDefaultValue();
    }

    public File getFoutFile() {
        return this.fout;
    }

    public String getFoutPattern() {
        return this.foutPattern;
    }

    public L getLoader() {
        return this.loader;
    }

    public int getMsgMode() {
        return this.msgMode;
    }

    public SvgTargets[] getSupportedTargetts() {
        return this.aoTarget.getSupportedTargets();
    }

    public SvgTargets getTarget() {
        return this.aoTarget.getTarget();
    }

    public String getTargetValue() {
        return (String)this.aoTarget.getValue();
    }

    public ArrayList<String> getWarnings() {
        return this.warnings;
    }

    public boolean processLayers() {
        return this.aoLayers.inCli();
    }

    public String setInput() {
        if (StringUtils.isBlank((CharSequence)((CharSequence)this.aoFileIn.getCliValue()))) {
            return "no input file given";
        }
        String fn = (String)this.aoFileIn.getValue();
        File testFD = new File(fn);
        if (!testFD.exists()) {
            return "input file <" + fn + "> does not exist, please check path and filename";
        }
        if (!testFD.isFile()) {
            return "input file <" + fn + "> is not a file, please check path and filename";
        }
        if (!testFD.canRead()) {
            return "cannot read input file <" + fn + ">, please file permissions";
        }
        this.fin = fn;
        return ((SV_DocumentLoader)this.loader).load(this.fin);
    }

    public void setMessageMode() {
        if (this.aoQuiet.inCli()) {
            this.msgMode = P_OPTION_QUIET;
            return;
        }
        if (this.aoVerbose.inCli()) {
            this.msgMode = P_OPTION_VERBOSE;
            return;
        }
        if (this.aoMsgProgress.inCli()) {
            this.msgMode |= P_OPTION_PROGRESS;
        }
        if (this.aoMsgWarning.inCli()) {
            this.msgMode |= P_OPTION_WARNING;
        }
        if (this.aoMsgDetail.inCli()) {
            this.msgMode |= P_OPTION_DEAILS;
        }
        if (this.aoNoErrors.inCli()) {
            this.msgMode = this.msgMode &= ~P_OPTION_ERROR;
        }
    }

    public String setOutput() {
        SvgTargets target = this.getTarget();
        if (target == null) {
            return "implementation error: cannot set output file w/o a valid target";
        }
        if (this.getFinFn() == null) {
            return "implementation error: no input file name set";
        }
        if (this.aoLayers.inCli() && !((SV_DocumentLoader)this.loader).hasInkscapeLayers()) {
            this.warnings.add("layers activated but input file has no layers, continue for single output file");
        }
        if ((this.aoLayers.inCli() || this.aoLayersIfExists.inCli()) && ((SV_DocumentLoader)this.loader).hasInkscapeLayers()) {
            return this.setOutputWithLayers(target);
        }
        return this.setOutputNoLayers(target);
    }

    private String setOutputNoLayers(SvgTargets target) {
        File fnF;
        for (ApplicationOption<?> ao : this.noLayersWarnings) {
            if (!ao.inCli()) continue;
            this.warnings.add("no layers processed but CLI option <" + ao.getCliOption().getLongOpt() + "> used, will be ignored");
        }
        String fn = null;
        if (this.aoFileOut.inCli()) {
            fn = (String)this.aoFileOut.getCliValue();
            if (StringUtils.isBlank((CharSequence)fn)) {
                return "output filename is blank";
            }
            if (fn.endsWith("." + target.name())) {
                return "output filename <" + fn + "> should not contain target file extension";
            }
        } else if (this.fin != null) {
            fn = this.fin;
            if (fn.endsWith("." + target.name())) {
                return "no output name given and target extension same as input extension, do not want to overwrite input file";
            }
            if (fn.endsWith(".svg")) {
                fn = fn.substring(0, fn.lastIndexOf(46));
            } else if (fn.endsWith(".svgz")) {
                fn = fn.substring(0, fn.lastIndexOf(46));
            }
        }
        if (this.aoDirOut.inCli()) {
            fn = fn.contains("/") ? (String)this.aoDirOut.getValue() + "/" + StringUtils.substringAfterLast((String)fn, (String)"/") : (String)this.aoDirOut.getValue() + "/" + fn;
            fn = StringUtils.replace((String)fn, (String)"//", (String)"/");
        }
        if ((fnF = new File(fn = fn + "." + target.name())).exists() && fnF.isDirectory()) {
            return "output file <" + fn + "> exists but is a directory";
        }
        if (fnF.exists() && !this.aoOverwriteExisting.inCli()) {
            return "output file <" + fn + "> exists and no option <" + this.aoOverwriteExisting.getCliOption().getLongOpt() + "> used";
        }
        if (fnF.exists() && !fnF.canWrite() && this.aoOverwriteExisting.inCli()) {
            return "output file <" + fn + "> exists but cannot write to it";
        }
        File fnFParent = fnF.getParentFile();
        if (fnFParent != null) {
            if (fnFParent.exists() && !fnFParent.isDirectory()) {
                return "output directory <" + fnFParent.toString().replace('\\', '/') + "> exists but is not a directory";
            }
            if (!fnFParent.exists() && !this.aoCreateDirs.inCli()) {
                return "output directory <" + fnFParent.toString().replace('\\', '/') + "> does not exist and CLI option <" + this.aoCreateDirs.getCliOption().getLongOpt() + "> not used";
            }
        }
        if (this.aoSwitchOnLayers.inCli()) {
            ((SV_DocumentLoader)this.loader).switchOnAllLayers();
        }
        this.aoFileOut.setDefaultValue((Object)fn);
        this.fout = fnF;
        return null;
    }

    private String setOutputWithLayers(SvgTargets target) {
        for (ApplicationOption<?> ao : this.withLayersWarnings) {
            if (!ao.inCli()) continue;
            this.warnings.add("layers processed but CLI option <" + ao.getCliOption().getLongOpt() + "> used, will be ignored");
        }
        String dout = (String)this.aoDirOut.getValue();
        File testDir = new File(dout);
        if (testDir.exists() && !testDir.isDirectory()) {
            return "output directory <" + dout + "> exists but is not a directory";
        }
        if (testDir.exists() && !testDir.canWrite()) {
            return "output directory <" + dout + "> exists but cannot write into it, check permissions";
        }
        if (!testDir.exists() && !this.aoCreateDirs.inCli()) {
            return "output directory <" + dout + "> does not exist and CLI option <" + this.aoCreateDirs.getCliOption().getLongOpt() + "> not used";
        }
        if (!this.aoFoutLayerId.inCli() && !this.aoFoutLayerIndex.inCli()) {
            return "processing layers but neither <" + this.aoFoutLayerId.getCliOption().getLongOpt() + "> nor <" + this.aoFoutLayerIndex.getCliOption().getLongOpt() + "> options requestes, amigious output file names";
        }
        StrBuilder pattern = new StrBuilder();
        pattern.append(dout);
        if (!pattern.endsWith("/")) {
            pattern.append('/');
        }
        if (!this.aoFoutNoBasename.inCli()) {
            if (this.aoUseBaseName.inCli()) {
                pattern.append((String)this.aoUseBaseName.getValue());
            } else {
                String bn = StringUtils.substringAfterLast((String)this.fin, (String)"/");
                bn = StringUtils.substringBeforeLast((String)bn, (String)".");
                pattern.append(bn);
            }
        }
        if (this.aoFoutLayerIndex.inCli()) {
            if (!pattern.endsWith("/")) {
                pattern.append('-');
            }
            pattern.append(SUBST_PATTERN_INDEX);
        }
        if (this.aoFoutLayerId.inCli()) {
            if (!pattern.endsWith("/")) {
                pattern.append('-');
            }
            pattern.append(SUBST_PATTERN_ID);
        }
        this.dout = dout;
        this.doutFile = testDir;
        this.foutPattern = pattern.toString();
        return null;
    }

    public boolean doesKeepTempArtifacts() {
        return this.aoKeepTmpArtifacts.inCli();
    }
}

