/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.svg2vector.applications.fh;

import de.vandermeer.execs.options.ApplicationOption;
import de.vandermeer.svg2vector.applications.base.AppBase;
import de.vandermeer.svg2vector.applications.base.AppProperties;
import de.vandermeer.svg2vector.applications.base.SvgTargets;
import de.vandermeer.svg2vector.applications.fh.AO_BackgroundColor;
import de.vandermeer.svg2vector.applications.fh.AO_Clip;
import de.vandermeer.svg2vector.applications.fh.AO_NoBackground;
import de.vandermeer.svg2vector.applications.fh.AO_NotTransparent;
import de.vandermeer.svg2vector.applications.fh.converters.BatikLoader;
import de.vandermeer.svg2vector.applications.fh.converters.FhConverter;
import de.vandermeer.svg2vector.applications.fh.converters.Fh_Svg2Emf;
import de.vandermeer.svg2vector.applications.fh.converters.Fh_Svg2Pdf;
import de.vandermeer.svg2vector.applications.fh.converters.Fh_Svg2Svg;
import java.awt.Color;
import java.io.File;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.freehep.graphicsbase.util.UserProperties;

public class Svg2Vector_FH
extends AppBase<BatikLoader, AppProperties<BatikLoader>> {
    public static final String APP_NAME = "s2v-fh";
    public static final String APP_DISPLAY_NAME = "Svg2Vector FreeHep";
    public static final String APP_VERSION = "v2.0.0 build 170413 (13-Apr-17) for Java 1.8";
    AO_NotTransparent optionNotTransparent = new AO_NotTransparent(false, Character.valueOf('n'), "switch off transparency");
    AO_Clip optionClip = new AO_Clip(false, Character.valueOf('c'), "activate clip property");
    AO_BackgroundColor optionBackgroundColor = new AO_BackgroundColor(false, Character.valueOf('r'), "sets the background color");
    AO_NoBackground optionNoBackground = new AO_NoBackground(false, Character.valueOf('b'), "switch off background property");

    public Svg2Vector_FH() {
        super(new AppProperties<BatikLoader>(new SvgTargets[]{SvgTargets.pdf, SvgTargets.emf, SvgTargets.svg}, new BatikLoader()));
        this.addOption((ApplicationOption<?>)this.optionNotTransparent);
        this.addOption((ApplicationOption<?>)this.optionClip);
        this.addOption((ApplicationOption<?>)this.optionBackgroundColor);
        this.addOption((ApplicationOption<?>)this.optionNoBackground);
    }

    @Override
    public int executeApplication(String[] args) {
        String err;
        int ret = super.executeApplication(args);
        if (ret != 0) {
            return ret;
        }
        SvgTargets target = ((AppProperties)this.getProps()).getTarget();
        FhConverter converter = Svg2Vector_FH.TARGET_2_CONVERTER(target);
        if (converter == null) {
            this.printErrorMessage("no converter found for target <" + target.name() + ">");
            return -20;
        }
        converter.setPropertyTransparent(!this.optionNotTransparent.inCli());
        converter.setPropertyClip(this.optionClip.inCli());
        converter.setPropertyBackground(!this.optionNoBackground.inCli());
        converter.setPropertyTextAsShapes(((AppProperties)this.getProps()).doesTextAsShape());
        if (this.optionBackgroundColor.inCli()) {
            Color color = Color.getColor((String)this.optionBackgroundColor.getValue());
            converter.setPropertyBackgroundColor(color);
        }
        UserProperties up = converter.getProperties();
        Set keys = up.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            String val = up.getProperty(key);
            key = key.substring(key.lastIndexOf(46) + 1, key.length());
            this.printDetailMessage("using SVG property " + key + "=" + val);
        }
        BatikLoader loader = (BatikLoader)((AppProperties)this.getProps()).getLoader();
        if (((AppProperties)this.getProps()).doesLayers()) {
            for (Map.Entry<String, Integer> entry : loader.getLayers().entrySet()) {
                loader.switchOffAllLayers();
                loader.switchOnLayer(entry.getKey());
                this.printProgressMessage("processing layer " + entry.getKey());
                this.printDetailMessage("writing to file " + ((AppProperties)this.getProps()).getFnOut(entry) + "." + target.name());
                if (!((AppProperties)this.getProps()).canWriteFiles() || (err = converter.convertDocument(loader, new File(((AppProperties)this.getProps()).getFnOut(entry) + "." + target.name()))) == null) continue;
                this.printErrorMessage(err);
                return -99;
            }
        } else {
            this.printProgressMessage("converting input");
            this.printDetailMessage("writing to file " + ((AppProperties)this.getProps()).getFoutFile());
            if (((AppProperties)this.getProps()).canWriteFiles() && (err = converter.convertDocument(loader, ((AppProperties)this.getProps()).getFoutFile())) != null) {
                this.printErrorMessage(err);
                return -99;
            }
        }
        this.printProgressMessage("finished successfully");
        return 0;
    }

    public String getAppName() {
        return APP_NAME;
    }

    public String getAppDisplayName() {
        return APP_DISPLAY_NAME;
    }

    public String getAppDescription() {
        return "Converts SVG graphics into other vector formats using FreeHep libraries, with options for handling layers";
    }

    public String getAppVersion() {
        return APP_VERSION;
    }

    public static FhConverter TARGET_2_CONVERTER(SvgTargets target) {
        if (target == null) {
            return null;
        }
        switch (target) {
            case eps: 
            case png: 
            case ps: 
            case wmf: {
                break;
            }
            case pdf: {
                return new Fh_Svg2Pdf();
            }
            case svg: {
                return new Fh_Svg2Svg();
            }
            case emf: {
                return new Fh_Svg2Emf();
            }
        }
        return null;
    }
}

