/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.svg2vector.applications.fh.converters;

import de.vandermeer.svg2vector.applications.base.SV_DocumentLoader;
import java.awt.Dimension;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BatikLoader
extends SV_DocumentLoader {
    private BridgeContext bridgeContext;
    private Document svgDocument;
    private Dimension size;
    private final Map<String, Node> layerNodes = new HashMap<String, Node>();

    public static String getLabel(Node node) {
        if (node == null) {
            return null;
        }
        NamedNodeMap nnm = node.getAttributes();
        for (int i = 0; i < nnm.getLength(); ++i) {
            if (!"inkscape:label".equals(nnm.item(i).getNodeName())) continue;
            return nnm.item(i).getNodeValue();
        }
        return null;
    }

    static int getIndex(Node node) {
        if (node == null) {
            return 0;
        }
        NamedNodeMap nnm = node.getAttributes();
        for (int i = 0; i < nnm.getLength(); ++i) {
            if (!"id".equals(nnm.item(i).getNodeName())) continue;
            String index = nnm.item(i).getNodeValue();
            index = StringUtils.substringAfter((String)index, (String)"layer");
            return new Integer(index);
        }
        return 0;
    }

    @Override
    public String load(String fn) {
        Validate.notBlank((CharSequence)fn);
        if (!this.isLoaded) {
            this.bridgeContext = null;
            this.svgDocument = null;
            UserAgentAdapter userAgent = new UserAgentAdapter();
            DocumentLoader documentLoader = new DocumentLoader((UserAgent)userAgent);
            this.bridgeContext = new BridgeContext((UserAgent)userAgent, documentLoader);
            this.bridgeContext.setDynamic(true);
            try {
                this.svgDocument = documentLoader.loadDocument(new File(fn).toURI().toString());
            }
            catch (Exception ex) {
                this.bridgeContext = null;
                this.svgDocument = null;
                return this.getClass().getSimpleName() + ": exception loading svgDocument - " + ex.getMessage();
            }
            documentLoader.dispose();
            Element elem = this.svgDocument.getDocumentElement();
            this.size = new Dimension();
            try {
                this.size.setSize(Double.valueOf(elem.getAttribute("width")), Double.valueOf(elem.getAttribute("height")));
            }
            catch (Exception ex) {
                this.bridgeContext = null;
                this.svgDocument = null;
                this.size = null;
                return this.getClass().getSimpleName() + ": exception setting docucment size - " + ex.getMessage();
            }
            NodeList nodes = elem.getChildNodes();
            if (nodes != null) {
                for (int i = 0; i < nodes.getLength(); ++i) {
                    if (!"g".equals(nodes.item(i).getNodeName())) continue;
                    NamedNodeMap nnm = nodes.item(i).getAttributes();
                    for (int node = 0; node < nnm.getLength(); ++node) {
                        if (!"inkscape:groupmode".equals(nnm.item(node).getNodeName())) continue;
                        String id = BatikLoader.getLabel(nodes.item(i));
                        int index = BatikLoader.getIndex(nodes.item(i));
                        this.layers.put(id, index);
                        this.layerNodes.put(id, nodes.item(i));
                    }
                }
            }
        }
        this.isLoaded = true;
        return null;
    }

    @Override
    public void switchOnAllLayers() {
        block0: for (Node node : this.layerNodes.values()) {
            NamedNodeMap nnm = node.getAttributes();
            for (int i = 0; i < nnm.getLength(); ++i) {
                if (!"style".equals(nnm.item(i).getNodeName())) continue;
                nnm.item(i).setNodeValue("display:inline");
                continue block0;
            }
        }
    }

    @Override
    public void switchOffAllLayers() {
        block0: for (Node node : this.layerNodes.values()) {
            NamedNodeMap nnm = node.getAttributes();
            for (int i = 0; i < nnm.getLength(); ++i) {
                if (!"style".equals(nnm.item(i).getNodeName())) continue;
                nnm.item(i).setNodeValue("display:none");
                continue block0;
            }
        }
    }

    @Override
    public void switchOnLayer(String layer) {
        if (StringUtils.isBlank((CharSequence)layer)) {
            return;
        }
        Node node = this.layerNodes.get(layer);
        if (node == null) {
            return;
        }
        NamedNodeMap nnm = node.getAttributes();
        for (int i = 0; i < nnm.getLength(); ++i) {
            if (!"style".equals(nnm.item(i).getNodeName())) continue;
            nnm.item(i).setNodeValue("display:inline");
            return;
        }
    }

    public Document getDocument() {
        return this.svgDocument;
    }

    public BridgeContext getBridgeContext() {
        return this.bridgeContext;
    }

    public Dimension getSize() {
        return this.size;
    }
}

