/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.svg2vector.applications.fh.converters;

import de.vandermeer.svg2vector.applications.fh.converters.BatikLoader;
import de.vandermeer.svg2vector.applications.fh.converters.FhConverter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Properties;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.gvt.GraphicsNode;
import org.freehep.graphicsio.emf.EMFGraphics2D;

public class Fh_Svg2Emf
extends FhConverter {
    @Override
    public void setPropertyBackground(boolean on) {
        this.properties.setProperty(EMFGraphics2D.BACKGROUND, on);
    }

    @Override
    public void setPropertyBackgroundColor(Color color) {
        this.properties.setProperty(EMFGraphics2D.BACKGROUND_COLOR, color);
    }

    @Override
    public void setPropertyTransparent(boolean on) {
        this.properties.setProperty(EMFGraphics2D.TRANSPARENT, on);
    }

    @Override
    public String convertDocument(BatikLoader loader, File fout) {
        EMFGraphics2D emfGraphics2D;
        FileOutputStream emfStream;
        GVTBuilder gvtBuilder = new GVTBuilder();
        GraphicsNode rootNode = gvtBuilder.build(loader.getBridgeContext(), loader.getDocument());
        try {
            emfStream = new FileOutputStream(fout);
            emfGraphics2D = new EMFGraphics2D(fout, loader.getSize());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return "##";
        }
        emfGraphics2D.setProperties((Properties)this.properties);
        emfGraphics2D.setDeviceIndependent(true);
        emfGraphics2D.startExport();
        rootNode.paint((Graphics2D)emfGraphics2D);
        emfGraphics2D.endExport();
        emfGraphics2D.dispose();
        try {
            emfStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

