/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.svg2vector.applications.fh.converters;

import de.vandermeer.svg2vector.applications.fh.converters.BatikLoader;
import de.vandermeer.svg2vector.applications.fh.converters.FhConverter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.gvt.GraphicsNode;
import org.freehep.graphicsio.pdf.PDFGraphics2D;

public class Fh_Svg2Pdf
extends FhConverter {
    public Fh_Svg2Pdf() {
        this.properties.setProperty(PDFGraphics2D.PAGE_MARGINS, "0, 0, 0, 0");
    }

    @Override
    public void setPropertyBackground(boolean on) {
        this.properties.setProperty(PDFGraphics2D.BACKGROUND, on);
    }

    @Override
    public void setPropertyBackgroundColor(Color color) {
        this.properties.setProperty(PDFGraphics2D.BACKGROUND_COLOR, color);
    }

    @Override
    public void setPropertyTransparent(boolean on) {
        this.properties.setProperty(PDFGraphics2D.TRANSPARENT, on);
    }

    @Override
    public String convertDocument(BatikLoader loader, File fout) {
        PDFGraphics2D pdfGraphics2D;
        FileOutputStream pdfStream;
        GVTBuilder gvtBuilder = new GVTBuilder();
        GraphicsNode rootNode = gvtBuilder.build(loader.getBridgeContext(), loader.getDocument());
        try {
            pdfStream = new FileOutputStream(fout);
            pdfGraphics2D = new PDFGraphics2D((OutputStream)pdfStream, loader.getSize());
        }
        catch (IOException fnfe) {
            return "###";
        }
        this.properties.setProperty(PDFGraphics2D.PAGE_SIZE, PDFGraphics2D.CUSTOM_PAGE_SIZE);
        this.properties.setProperty(PDFGraphics2D.CUSTOM_PAGE_SIZE, loader.getSize());
        pdfGraphics2D.setProperties((Properties)this.properties);
        pdfGraphics2D.setDeviceIndependent(true);
        pdfGraphics2D.startExport();
        rootNode.paint((Graphics2D)pdfGraphics2D);
        pdfGraphics2D.endExport();
        pdfGraphics2D.dispose();
        try {
            pdfStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

