/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.svg2vector.applications.is;

import de.vandermeer.execs.options.AbstractApplicationOption;
import org.apache.commons.cli.Option;
import org.apache.commons.lang3.SystemUtils;

public class AO_InkscapeExecutable
extends AbstractApplicationOption<String> {
    public static String ENV_KEY = "INKSCAPE";
    public static String DEFAULT_WINDOWS = "C:/Program Files/Inkscape/inkscape.exe";
    public static String DEFAULT_UNIX = "/usr/bin/inkscape";

    public AO_InkscapeExecutable(Character shortOption) {
        super("path to Inkscape executable", "This option, if used, needs to point to the Inkscape executable. Some default values are set in the following way: first, the environment variable <" + ENV_KEY + "> is tested. If it is not null, it's value is set as default for the option. Next, if the underlying operating system is a Windows system (using Apache SystemUtils), the default value is set to <" + DEFAULT_WINDOWS + ">. Next, if the underlying operating system is a UNIX system (using Apache SystemUtils), the default value is set to <" + DEFAULT_UNIX + ">. In all other cases, no default value will be set.\nUsing the option in the command line will use the given executable and ignore any default settings.");
        Option.Builder builder = shortOption == null ? Option.builder() : Option.builder((String)shortOption.toString());
        builder.longOpt("is-exec");
        builder.hasArg().argName("PATH");
        builder.required(false);
        this.setCliOption(builder.build());
        String env = System.getenv(ENV_KEY);
        if (env != null) {
            this.setDefaultValue(env);
        } else if (SystemUtils.IS_OS_WINDOWS) {
            this.setDefaultValue("C:/Program Files/Inkscape/inkscape.exe");
        } else if (SystemUtils.IS_OS_UNIX) {
            this.setDefaultValue("/usr/bin/inkscape");
        }
    }

    public String convertValue(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }
}

