/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.svg2vector.applications.is;

import de.vandermeer.svg2vector.applications.base.AppProperties;
import de.vandermeer.svg2vector.applications.base.SvgTargets;
import de.vandermeer.svg2vector.applications.is.IsTargetOption;
import java.util.HashMap;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.StrBuilder;
import org.apache.commons.lang3.text.StrSubstitutor;

public class IsCmd {
    public static String SUBS_FIN = "${fin}";
    public static String SUBS_FOUT = "${fout}";
    protected final StrBuilder cmd = new StrBuilder();

    public IsCmd(IsCmd command) {
        Validate.notNull((Object)command);
        this.cmd.append(command.cmd.toCharArray());
    }

    public IsCmd(String isExec, SvgTargets target, AppProperties<?> properties) {
        Validate.notNull((Object)isExec);
        Validate.notNull((Object)((Object)target));
        Validate.notNull(properties);
        if (isExec.contains("\"")) {
            this.cmd.clear().append('\"');
        }
        this.cmd.append(isExec);
        if (isExec.contains("\"")) {
            this.cmd.clear().append('\"');
        }
        this.cmd.append(' ').append("--without-gui --export-area-page");
        if (properties.doesTextAsShape()) {
            this.cmd.append(" --export-text-to-path");
        }
        this.cmd.append(" --file=").append(SUBS_FIN);
        this.cmd.append(' ').append(this.target2CLI(target, true)).append('=').append(SUBS_FOUT);
    }

    public IsCmd appendTargetSettings(SvgTargets target, IsTargetOption ... options) {
        Validate.notNull((Object)((Object)target));
        Validate.notNull((Object)options);
        Validate.noNullElements((Object[])options);
        for (IsTargetOption to : options) {
            if (target != to.getTarget() || !to.inCli() || to.getValue() == null) continue;
            this.cmd.append(' ').append(to.getIsCmd()).append('=').append((String)to.getValue());
        }
        return this;
    }

    public String substitute(String fin, String fout) {
        Validate.notBlank((CharSequence)fin);
        Validate.notBlank((CharSequence)fout);
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        valuesMap.put("fin", fin);
        valuesMap.put("fout", fout);
        StrSubstitutor sub = new StrSubstitutor(valuesMap);
        return sub.replace(this.cmd.toString());
    }

    public IsCmd appendSelectedNode(String nodeId) {
        Validate.notBlank((CharSequence)nodeId);
        this.cmd.append(" -j -i=").append(nodeId);
        this.cmd.append(" --select=").append(nodeId);
        return this;
    }

    private String target2CLI(SvgTargets target, boolean assumeLong) {
        if (target == null) {
            return null;
        }
        switch (target) {
            case emf: {
                return assumeLong ? "--export-emf" : "-M";
            }
            case eps: {
                return assumeLong ? "--export-eps" : "-E";
            }
            case pdf: {
                return assumeLong ? "--export-pdf" : "-A";
            }
            case png: {
                return assumeLong ? "--export-png" : "-e";
            }
            case ps: {
                return assumeLong ? "--export-ps" : "-P";
            }
            case svg: {
                return assumeLong ? "--export-plain-svg" : "-l";
            }
            case wmf: {
                return assumeLong ? "--export-wmf" : "-m";
            }
        }
        return null;
    }

    public String toString() {
        return this.cmd.toString();
    }
}

