/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.svg2vector.applications.is;

import de.vandermeer.svg2vector.applications.base.SV_DocumentLoader;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class IsLoader
extends SV_DocumentLoader {
    protected ArrayList<String> lines;

    @Override
    public String load(String fn) {
        Validate.notBlank((CharSequence)fn);
        if (!this.isLoaded) {
            try {
                String str;
                GZIPInputStream decompressed = new GZIPInputStream(new FileInputStream(fn));
                BufferedReader in = new BufferedReader(new InputStreamReader(decompressed));
                this.lines = new ArrayList();
                while ((str = in.readLine()) != null) {
                    this.lines.add(str);
                }
                in.close();
                ((InputStream)decompressed).close();
                this.isLoaded = true;
            }
            catch (ZipException decompressed) {
            }
            catch (IOException e) {
                this.lines = null;
                return this.getClass().getSimpleName() + ": IO error reading GZIP file <" + fn + ">: " + e.getMessage();
            }
        }
        if (!this.isLoaded) {
            try {
                String str;
                BufferedReader in = new BufferedReader(new FileReader(fn));
                this.lines = new ArrayList();
                while ((str = in.readLine()) != null) {
                    this.lines.add(str);
                }
                in.close();
                this.isLoaded = true;
            }
            catch (FileNotFoundException e) {
                this.lines = null;
                return this.getClass().getSimpleName() + ": FileNotFoundException error reading plain file <" + fn + ">: " + e.getMessage();
            }
            catch (IOException e) {
                this.lines = null;
                return this.getClass().getSimpleName() + ": IO error reading plain file <" + fn + ">: " + e.getMessage();
            }
        }
        boolean inLayer = false;
        String id = null;
        String index = null;
        for (int i = 0; i < this.lines.size(); ++i) {
            if (this.lines.get(i).contains("inkscape:groupmode=\"layer\"")) {
                inLayer = true;
            }
            if (inLayer && this.lines.get(i).contains("id=\"layer")) {
                index = StringUtils.substringBetween((String)this.lines.get(i), (String)"\"");
                index = StringUtils.substringAfter((String)index, (String)"layer");
            }
            if (inLayer && this.lines.get(i).contains("inkscape:label=\"")) {
                id = StringUtils.substringBetween((String)this.lines.get(i), (String)"\"");
            }
            if (id == null || index == null) continue;
            this.layers.put(id, new Integer(index));
            inLayer = false;
            id = null;
            index = null;
        }
        return null;
    }

    @Override
    public void switchOnAllLayers() {
        boolean inLayer = false;
        for (int i = 0; i < this.lines.size(); ++i) {
            if (this.lines.get(i).contains("inkscape:groupmode=\"layer\"")) {
                inLayer = true;
            }
            if (!inLayer || !this.lines.get(i).contains("style=\"display:")) continue;
            this.lines.set(i, this.lines.get(i).replace("display:none", "display:inline"));
            inLayer = false;
        }
    }

    @Override
    public void switchOffAllLayers() {
        boolean inLayer = false;
        for (int i = 0; i < this.lines.size(); ++i) {
            if (this.lines.get(i).contains("inkscape:groupmode=\"layer\"")) {
                inLayer = true;
            }
            if (!inLayer || !this.lines.get(i).contains("style=\"display:")) continue;
            this.lines.set(i, this.lines.get(i).replace("display:inline", "display:none"));
            inLayer = false;
        }
    }

    @Override
    public void switchOnLayer(String layer) {
        if (StringUtils.isBlank((CharSequence)layer)) {
            return;
        }
        if (!this.getLayers().keySet().contains(layer)) {
            return;
        }
        boolean inLayer = false;
        boolean foundLayer = false;
        for (int i = 0; i < this.lines.size(); ++i) {
            if (this.lines.get(i).contains("inkscape:groupmode=\"layer\"")) {
                inLayer = true;
            }
            if (inLayer && this.lines.get(i).contains("inkscape:label=\"") && layer.equals(StringUtils.substringBetween((String)this.lines.get(i), (String)"\""))) {
                foundLayer = true;
            }
            if (!inLayer || !foundLayer || !this.lines.get(i).contains("style=\"display:")) continue;
            this.lines.set(i, this.lines.get(i).replace("display:none", "display:inline"));
            inLayer = false;
            foundLayer = false;
        }
    }

    public ArrayList<String> getLines() {
        return this.lines;
    }
}

